package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendVcode invokes the companyreg.SendVcode API synchronously
// api document: https://help.aliyun.com/api/companyreg/sendvcode.html
func (client *Client) SendVcode(request *SendVcodeRequest) (response *SendVcodeResponse, err error) {
	response = CreateSendVcodeResponse()
	err = client.DoAction(request, response)
	return
}

// SendVcodeWithChan invokes the companyreg.SendVcode API asynchronously
// api document: https://help.aliyun.com/api/companyreg/sendvcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendVcodeWithChan(request *SendVcodeRequest) (<-chan *SendVcodeResponse, <-chan error) {
	responseChan := make(chan *SendVcodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendVcode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendVcodeWithCallback invokes the companyreg.SendVcode API asynchronously
// api document: https://help.aliyun.com/api/companyreg/sendvcode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendVcodeWithCallback(request *SendVcodeRequest, callback func(response *SendVcodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendVcodeResponse
		var err error
		defer close(result)
		response, err = client.SendVcode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendVcodeRequest is the request struct for api SendVcode
type SendVcodeRequest struct {
	*requests.RpcRequest
	Mobile  string `position:"Query" name:"Mobile"`
	BizCode string `position:"Query" name:"BizCode"`
}

// SendVcodeResponse is the response struct for api SendVcode
type SendVcodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendVcodeRequest creates a request to invoke SendVcode API
func CreateSendVcodeRequest() (request *SendVcodeRequest) {
	request = &SendVcodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "SendVcode", "companyreg", "openAPI")
	return
}

// CreateSendVcodeResponse creates a response to parse from SendVcode response
func CreateSendVcodeResponse() (response *SendVcodeResponse) {
	response = &SendVcodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
