package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepository invokes the cr.GetRepository API synchronously
// api document: https://help.aliyun.com/api/cr/getrepository.html
func (client *Client) GetRepository(request *GetRepositoryRequest) (response *GetRepositoryResponse, err error) {
	response = CreateGetRepositoryResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepositoryWithChan invokes the cr.GetRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepositoryWithChan(request *GetRepositoryRequest) (<-chan *GetRepositoryResponse, <-chan error) {
	responseChan := make(chan *GetRepositoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepository(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepositoryWithCallback invokes the cr.GetRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepositoryWithCallback(request *GetRepositoryRequest, callback func(response *GetRepositoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepositoryResponse
		var err error
		defer close(result)
		response, err = client.GetRepository(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepositoryRequest is the request struct for api GetRepository
type GetRepositoryRequest struct {
	*requests.RpcRequest
	RepoId            string `position:"Query" name:"RepoId"`
	InstanceId        string `position:"Query" name:"InstanceId"`
	RepoNamespaceName string `position:"Query" name:"RepoNamespaceName"`
	RepoName          string `position:"Query" name:"RepoName"`
}

// GetRepositoryResponse is the response struct for api GetRepository
type GetRepositoryResponse struct {
	*responses.BaseResponse
	GetRepositoryIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                   string `json:"Code" xml:"Code"`
	RequestId              string `json:"RequestId" xml:"RequestId"`
	InstanceId             string `json:"InstanceId" xml:"InstanceId"`
	RepoId                 string `json:"RepoId" xml:"RepoId"`
	RepoNamespaceName      string `json:"RepoNamespaceName" xml:"RepoNamespaceName"`
	RepoName               string `json:"RepoName" xml:"RepoName"`
	RepoStatus             string `json:"RepoStatus" xml:"RepoStatus"`
	RepoType               string `json:"RepoType" xml:"RepoType"`
	RepoBuildType          string `json:"RepoBuildType" xml:"RepoBuildType"`
	Summary                string `json:"Summary" xml:"Summary"`
	Detail                 string `json:"Detail" xml:"Detail"`
	CreateTime             int64  `json:"CreateTime" xml:"CreateTime"`
	ModifiedTime           int64  `json:"ModifiedTime" xml:"ModifiedTime"`
}

// CreateGetRepositoryRequest creates a request to invoke GetRepository API
func CreateGetRepositoryRequest() (request *GetRepositoryRequest) {
	request = &GetRepositoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetRepository", "cr", "openAPI")
	return
}

// CreateGetRepositoryResponse creates a response to parse from GetRepository response
func CreateGetRepositoryResponse() (response *GetRepositoryResponse) {
	response = &GetRepositoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
