package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRepoTrigger invokes the cr.UpdateRepoTrigger API synchronously
// api document: https://help.aliyun.com/api/cr/updaterepotrigger.html
func (client *Client) UpdateRepoTrigger(request *UpdateRepoTriggerRequest) (response *UpdateRepoTriggerResponse, err error) {
	response = CreateUpdateRepoTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRepoTriggerWithChan invokes the cr.UpdateRepoTrigger API asynchronously
// api document: https://help.aliyun.com/api/cr/updaterepotrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRepoTriggerWithChan(request *UpdateRepoTriggerRequest) (<-chan *UpdateRepoTriggerResponse, <-chan error) {
	responseChan := make(chan *UpdateRepoTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRepoTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRepoTriggerWithCallback invokes the cr.UpdateRepoTrigger API asynchronously
// api document: https://help.aliyun.com/api/cr/updaterepotrigger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRepoTriggerWithCallback(request *UpdateRepoTriggerRequest, callback func(response *UpdateRepoTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRepoTriggerResponse
		var err error
		defer close(result)
		response, err = client.UpdateRepoTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRepoTriggerRequest is the request struct for api UpdateRepoTrigger
type UpdateRepoTriggerRequest struct {
	*requests.RpcRequest
	RepoId      string `position:"Query" name:"RepoId"`
	TriggerTag  string `position:"Query" name:"TriggerTag"`
	TriggerId   string `position:"Query" name:"TriggerId"`
	TriggerType string `position:"Query" name:"TriggerType"`
	TriggerUrl  string `position:"Query" name:"TriggerUrl"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	TriggerName string `position:"Query" name:"TriggerName"`
}

// UpdateRepoTriggerResponse is the response struct for api UpdateRepoTrigger
type UpdateRepoTriggerResponse struct {
	*responses.BaseResponse
	UpdateRepoTriggerIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                       string `json:"Code" xml:"Code"`
	RequestId                  string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateRepoTriggerRequest creates a request to invoke UpdateRepoTrigger API
func CreateUpdateRepoTriggerRequest() (request *UpdateRepoTriggerRequest) {
	request = &UpdateRepoTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "UpdateRepoTrigger", "cr", "openAPI")
	return
}

// CreateUpdateRepoTriggerResponse creates a response to parse from UpdateRepoTrigger response
func CreateUpdateRepoTriggerResponse() (response *UpdateRepoTriggerResponse) {
	response = &UpdateRepoTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
