package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStopDcdnDomain invokes the dcdn.BatchStopDcdnDomain API synchronously
// api document: https://help.aliyun.com/api/dcdn/batchstopdcdndomain.html
func (client *Client) BatchStopDcdnDomain(request *BatchStopDcdnDomainRequest) (response *BatchStopDcdnDomainResponse, err error) {
	response = CreateBatchStopDcdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStopDcdnDomainWithChan invokes the dcdn.BatchStopDcdnDomain API asynchronously
// api document: https://help.aliyun.com/api/dcdn/batchstopdcdndomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchStopDcdnDomainWithChan(request *BatchStopDcdnDomainRequest) (<-chan *BatchStopDcdnDomainResponse, <-chan error) {
	responseChan := make(chan *BatchStopDcdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStopDcdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStopDcdnDomainWithCallback invokes the dcdn.BatchStopDcdnDomain API asynchronously
// api document: https://help.aliyun.com/api/dcdn/batchstopdcdndomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchStopDcdnDomainWithCallback(request *BatchStopDcdnDomainRequest, callback func(response *BatchStopDcdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStopDcdnDomainResponse
		var err error
		defer close(result)
		response, err = client.BatchStopDcdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStopDcdnDomainRequest is the request struct for api BatchStopDcdnDomain
type BatchStopDcdnDomainRequest struct {
	*requests.RpcRequest
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchStopDcdnDomainResponse is the response struct for api BatchStopDcdnDomain
type BatchStopDcdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchStopDcdnDomainRequest creates a request to invoke BatchStopDcdnDomain API
func CreateBatchStopDcdnDomainRequest() (request *BatchStopDcdnDomainRequest) {
	request = &BatchStopDcdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchStopDcdnDomain", "", "")
	return
}

// CreateBatchStopDcdnDomainResponse creates a response to parse from BatchStopDcdnDomain response
func CreateBatchStopDcdnDomainResponse() (response *BatchStopDcdnDomainResponse) {
	response = &BatchStopDcdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
