package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePreCheckResult invokes the drds.DescribePreCheckResult API synchronously
// api document: https://help.aliyun.com/api/drds/describeprecheckresult.html
func (client *Client) DescribePreCheckResult(request *DescribePreCheckResultRequest) (response *DescribePreCheckResultResponse, err error) {
	response = CreateDescribePreCheckResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePreCheckResultWithChan invokes the drds.DescribePreCheckResult API asynchronously
// api document: https://help.aliyun.com/api/drds/describeprecheckresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePreCheckResultWithChan(request *DescribePreCheckResultRequest) (<-chan *DescribePreCheckResultResponse, <-chan error) {
	responseChan := make(chan *DescribePreCheckResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePreCheckResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePreCheckResultWithCallback invokes the drds.DescribePreCheckResult API asynchronously
// api document: https://help.aliyun.com/api/drds/describeprecheckresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePreCheckResultWithCallback(request *DescribePreCheckResultRequest, callback func(response *DescribePreCheckResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePreCheckResultResponse
		var err error
		defer close(result)
		response, err = client.DescribePreCheckResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePreCheckResultRequest is the request struct for api DescribePreCheckResult
type DescribePreCheckResultRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	TaskId         string `position:"Query" name:"TaskId"`
}

// DescribePreCheckResultResponse is the response struct for api DescribePreCheckResult
type DescribePreCheckResultResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	PreCheckResult PreCheckResult `json:"PreCheckResult" xml:"PreCheckResult"`
}

// CreateDescribePreCheckResultRequest creates a request to invoke DescribePreCheckResult API
func CreateDescribePreCheckResultRequest() (request *DescribePreCheckResultRequest) {
	request = &DescribePreCheckResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribePreCheckResult", "Drds", "openAPI")
	return
}

// CreateDescribePreCheckResultResponse creates a response to parse from DescribePreCheckResult response
func CreateDescribePreCheckResultResponse() (response *DescribePreCheckResultResponse) {
	response = &DescribePreCheckResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
