package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserReports invokes the drds.ListUserReports API synchronously
// api document: https://help.aliyun.com/api/drds/listuserreports.html
func (client *Client) ListUserReports(request *ListUserReportsRequest) (response *ListUserReportsResponse, err error) {
	response = CreateListUserReportsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserReportsWithChan invokes the drds.ListUserReports API asynchronously
// api document: https://help.aliyun.com/api/drds/listuserreports.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUserReportsWithChan(request *ListUserReportsRequest) (<-chan *ListUserReportsResponse, <-chan error) {
	responseChan := make(chan *ListUserReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserReportsWithCallback invokes the drds.ListUserReports API asynchronously
// api document: https://help.aliyun.com/api/drds/listuserreports.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUserReportsWithCallback(request *ListUserReportsRequest, callback func(response *ListUserReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserReportsResponse
		var err error
		defer close(result)
		response, err = client.ListUserReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserReportsRequest is the request struct for api ListUserReports
type ListUserReportsRequest struct {
	*requests.RpcRequest
	ReportId       requests.Integer `position:"Query" name:"ReportId"`
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
}

// ListUserReportsResponse is the response struct for api ListUserReports
type ListUserReportsResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Success             bool                `json:"Success" xml:"Success"`
	SqlComparisonReport SqlComparisonReport `json:"sqlComparisonReport" xml:"sqlComparisonReport"`
}

// CreateListUserReportsRequest creates a request to invoke ListUserReports API
func CreateListUserReportsRequest() (request *ListUserReportsRequest) {
	request = &ListUserReportsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "ListUserReports", "Drds", "openAPI")
	return
}

// CreateListUserReportsResponse creates a response to parse from ListUserReports response
func CreateListUserReportsResponse() (response *ListUserReportsResponse) {
	response = &ListUserReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
