package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetupDrdsParams invokes the drds.SetupDrdsParams API synchronously
// api document: https://help.aliyun.com/api/drds/setupdrdsparams.html
func (client *Client) SetupDrdsParams(request *SetupDrdsParamsRequest) (response *SetupDrdsParamsResponse, err error) {
	response = CreateSetupDrdsParamsResponse()
	err = client.DoAction(request, response)
	return
}

// SetupDrdsParamsWithChan invokes the drds.SetupDrdsParams API asynchronously
// api document: https://help.aliyun.com/api/drds/setupdrdsparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetupDrdsParamsWithChan(request *SetupDrdsParamsRequest) (<-chan *SetupDrdsParamsResponse, <-chan error) {
	responseChan := make(chan *SetupDrdsParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetupDrdsParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetupDrdsParamsWithCallback invokes the drds.SetupDrdsParams API asynchronously
// api document: https://help.aliyun.com/api/drds/setupdrdsparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetupDrdsParamsWithCallback(request *SetupDrdsParamsRequest, callback func(response *SetupDrdsParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetupDrdsParamsResponse
		var err error
		defer close(result)
		response, err = client.SetupDrdsParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetupDrdsParamsRequest is the request struct for api SetupDrdsParams
type SetupDrdsParamsRequest struct {
	*requests.RpcRequest
	ParamLevel     string                 `position:"Query" name:"ParamLevel"`
	Data           *[]SetupDrdsParamsData `position:"Query" name:"Data"  type:"Repeated"`
	DrdsInstanceId string                 `position:"Query" name:"DrdsInstanceId"`
}

// SetupDrdsParamsData is a repeated param struct in SetupDrdsParamsRequest
type SetupDrdsParamsData struct {
	ParamType         string `name:"ParamType"`
	DbName            string `name:"DbName"`
	ParamRanges       string `name:"ParamRanges"`
	ParamVariableName string `name:"ParamVariableName"`
	ParamValue        string `name:"ParamValue"`
}

// SetupDrdsParamsResponse is the response struct for api SetupDrdsParams
type SetupDrdsParamsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSetupDrdsParamsRequest creates a request to invoke SetupDrdsParams API
func CreateSetupDrdsParamsRequest() (request *SetupDrdsParamsRequest) {
	request = &SetupDrdsParamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SetupDrdsParams", "Drds", "openAPI")
	return
}

// CreateSetupDrdsParamsResponse creates a response to parse from SetupDrdsParams response
func CreateSetupDrdsParamsResponse() (response *SetupDrdsParamsResponse) {
	response = &SetupDrdsParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
