package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitSwitchTableShardingKeyModify invokes the drds.SubmitSwitchTableShardingKeyModify API synchronously
// api document: https://help.aliyun.com/api/drds/submitswitchtableshardingkeymodify.html
func (client *Client) SubmitSwitchTableShardingKeyModify(request *SubmitSwitchTableShardingKeyModifyRequest) (response *SubmitSwitchTableShardingKeyModifyResponse, err error) {
	response = CreateSubmitSwitchTableShardingKeyModifyResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitSwitchTableShardingKeyModifyWithChan invokes the drds.SubmitSwitchTableShardingKeyModify API asynchronously
// api document: https://help.aliyun.com/api/drds/submitswitchtableshardingkeymodify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitSwitchTableShardingKeyModifyWithChan(request *SubmitSwitchTableShardingKeyModifyRequest) (<-chan *SubmitSwitchTableShardingKeyModifyResponse, <-chan error) {
	responseChan := make(chan *SubmitSwitchTableShardingKeyModifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitSwitchTableShardingKeyModify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitSwitchTableShardingKeyModifyWithCallback invokes the drds.SubmitSwitchTableShardingKeyModify API asynchronously
// api document: https://help.aliyun.com/api/drds/submitswitchtableshardingkeymodify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitSwitchTableShardingKeyModifyWithCallback(request *SubmitSwitchTableShardingKeyModifyRequest, callback func(response *SubmitSwitchTableShardingKeyModifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitSwitchTableShardingKeyModifyResponse
		var err error
		defer close(result)
		response, err = client.SubmitSwitchTableShardingKeyModify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitSwitchTableShardingKeyModifyRequest is the request struct for api SubmitSwitchTableShardingKeyModify
type SubmitSwitchTableShardingKeyModifyRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
	TaskId         string `position:"Query" name:"TaskId"`
}

// SubmitSwitchTableShardingKeyModifyResponse is the response struct for api SubmitSwitchTableShardingKeyModify
type SubmitSwitchTableShardingKeyModifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSubmitSwitchTableShardingKeyModifyRequest creates a request to invoke SubmitSwitchTableShardingKeyModify API
func CreateSubmitSwitchTableShardingKeyModifyRequest() (request *SubmitSwitchTableShardingKeyModifyRequest) {
	request = &SubmitSwitchTableShardingKeyModifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SubmitSwitchTableShardingKeyModify", "Drds", "openAPI")
	return
}

// CreateSubmitSwitchTableShardingKeyModifyResponse creates a response to parse from SubmitSwitchTableShardingKeyModify response
func CreateSubmitSwitchTableShardingKeyModifyResponse() (response *SubmitSwitchTableShardingKeyModifyResponse) {
	response = &SubmitSwitchTableShardingKeyModifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
