package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitTableShardingKeyModify invokes the drds.SubmitTableShardingKeyModify API synchronously
// api document: https://help.aliyun.com/api/drds/submittableshardingkeymodify.html
func (client *Client) SubmitTableShardingKeyModify(request *SubmitTableShardingKeyModifyRequest) (response *SubmitTableShardingKeyModifyResponse, err error) {
	response = CreateSubmitTableShardingKeyModifyResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitTableShardingKeyModifyWithChan invokes the drds.SubmitTableShardingKeyModify API asynchronously
// api document: https://help.aliyun.com/api/drds/submittableshardingkeymodify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitTableShardingKeyModifyWithChan(request *SubmitTableShardingKeyModifyRequest) (<-chan *SubmitTableShardingKeyModifyResponse, <-chan error) {
	responseChan := make(chan *SubmitTableShardingKeyModifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitTableShardingKeyModify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitTableShardingKeyModifyWithCallback invokes the drds.SubmitTableShardingKeyModify API asynchronously
// api document: https://help.aliyun.com/api/drds/submittableshardingkeymodify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitTableShardingKeyModifyWithCallback(request *SubmitTableShardingKeyModifyRequest, callback func(response *SubmitTableShardingKeyModifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitTableShardingKeyModifyResponse
		var err error
		defer close(result)
		response, err = client.SubmitTableShardingKeyModify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitTableShardingKeyModifyRequest is the request struct for api SubmitTableShardingKeyModify
type SubmitTableShardingKeyModifyRequest struct {
	*requests.RpcRequest
	TbPartitions         string           `position:"Query" name:"TbPartitions"`
	IsShard              requests.Boolean `position:"Query" name:"IsShard"`
	TbShardingFunction   string           `position:"Query" name:"TbShardingFunction"`
	DbShardingColumnList string           `position:"Query" name:"DbShardingColumnList"`
	TbComputeLength      string           `position:"Query" name:"TbComputeLength"`
	TbRightShiftOffset   string           `position:"Query" name:"TbRightShiftOffset"`
	DbComputeLength      string           `position:"Query" name:"DbComputeLength"`
	SrcTableName         string           `position:"Query" name:"SrcTableName"`
	DbRightShiftOffset   requests.Integer `position:"Query" name:"DbRightShiftOffset"`
	TargetTableName      string           `position:"Query" name:"TargetTableName"`
	DrdsInstanceId       string           `position:"Query" name:"DrdsInstanceId"`
	DbShardingFunction   string           `position:"Query" name:"DbShardingFunction"`
	DbName               string           `position:"Query" name:"DbName"`
	TbShardingColumnList string           `position:"Query" name:"TbShardingColumnList"`
}

// SubmitTableShardingKeyModifyResponse is the response struct for api SubmitTableShardingKeyModify
type SubmitTableShardingKeyModifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSubmitTableShardingKeyModifyRequest creates a request to invoke SubmitTableShardingKeyModify API
func CreateSubmitTableShardingKeyModifyRequest() (request *SubmitTableShardingKeyModifyRequest) {
	request = &SubmitTableShardingKeyModifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SubmitTableShardingKeyModify", "Drds", "openAPI")
	return
}

// CreateSubmitTableShardingKeyModifyResponse creates a response to parse from SubmitTableShardingKeyModify response
func CreateSubmitTableShardingKeyModifyResponse() (response *SubmitTableShardingKeyModifyResponse) {
	response = &SubmitTableShardingKeyModifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
