package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCallDetailByTaskId invokes the dyvmsapi.QueryCallDetailByTaskId API synchronously
// api document: https://help.aliyun.com/api/dyvmsapi/querycalldetailbytaskid.html
func (client *Client) QueryCallDetailByTaskId(request *QueryCallDetailByTaskIdRequest) (response *QueryCallDetailByTaskIdResponse, err error) {
	response = CreateQueryCallDetailByTaskIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCallDetailByTaskIdWithChan invokes the dyvmsapi.QueryCallDetailByTaskId API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/querycalldetailbytaskid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCallDetailByTaskIdWithChan(request *QueryCallDetailByTaskIdRequest) (<-chan *QueryCallDetailByTaskIdResponse, <-chan error) {
	responseChan := make(chan *QueryCallDetailByTaskIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCallDetailByTaskId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCallDetailByTaskIdWithCallback invokes the dyvmsapi.QueryCallDetailByTaskId API asynchronously
// api document: https://help.aliyun.com/api/dyvmsapi/querycalldetailbytaskid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCallDetailByTaskIdWithCallback(request *QueryCallDetailByTaskIdRequest, callback func(response *QueryCallDetailByTaskIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCallDetailByTaskIdResponse
		var err error
		defer close(result)
		response, err = client.QueryCallDetailByTaskId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCallDetailByTaskIdRequest is the request struct for api QueryCallDetailByTaskId
type QueryCallDetailByTaskIdRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Callee               string           `position:"Query" name:"Callee"`
	TaskId               string           `position:"Query" name:"TaskId"`
	QueryDate            requests.Integer `position:"Query" name:"QueryDate"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryCallDetailByTaskIdResponse is the response struct for api QueryCallDetailByTaskId
type QueryCallDetailByTaskIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateQueryCallDetailByTaskIdRequest creates a request to invoke QueryCallDetailByTaskId API
func CreateQueryCallDetailByTaskIdRequest() (request *QueryCallDetailByTaskIdRequest) {
	request = &QueryCallDetailByTaskIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "QueryCallDetailByTaskId", "dyvms", "openAPI")
	return
}

// CreateQueryCallDetailByTaskIdResponse creates a response to parse from QueryCallDetailByTaskId response
func CreateQueryCallDetailByTaskIdResponse() (response *QueryCallDetailByTaskIdResponse) {
	response = &QueryCallDetailByTaskIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
