package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMaintenanceProperty invokes the ecs.DescribeMaintenanceProperty API synchronously
// api document: https://help.aliyun.com/api/ecs/describemaintenanceproperty.html
func (client *Client) DescribeMaintenanceProperty(request *DescribeMaintenancePropertyRequest) (response *DescribeMaintenancePropertyResponse, err error) {
	response = CreateDescribeMaintenancePropertyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMaintenancePropertyWithChan invokes the ecs.DescribeMaintenanceProperty API asynchronously
// api document: https://help.aliyun.com/api/ecs/describemaintenanceproperty.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMaintenancePropertyWithChan(request *DescribeMaintenancePropertyRequest) (<-chan *DescribeMaintenancePropertyResponse, <-chan error) {
	responseChan := make(chan *DescribeMaintenancePropertyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMaintenanceProperty(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMaintenancePropertyWithCallback invokes the ecs.DescribeMaintenanceProperty API asynchronously
// api document: https://help.aliyun.com/api/ecs/describemaintenanceproperty.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMaintenancePropertyWithCallback(request *DescribeMaintenancePropertyRequest, callback func(response *DescribeMaintenancePropertyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMaintenancePropertyResponse
		var err error
		defer close(result)
		response, err = client.DescribeMaintenanceProperty(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMaintenancePropertyRequest is the request struct for api DescribeMaintenanceProperty
type DescribeMaintenancePropertyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           *[]string        `position:"Query" name:"InstanceId"  type:"Repeated"`
}

// DescribeMaintenancePropertyResponse is the response struct for api DescribeMaintenanceProperty
type DescribeMaintenancePropertyResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	TotalCount             int                    `json:"TotalCount" xml:"TotalCount"`
	PageNumber             int                    `json:"PageNumber" xml:"PageNumber"`
	PageSize               int                    `json:"PageSize" xml:"PageSize"`
	MaintenancePropertySet MaintenancePropertySet `json:"MaintenancePropertySet" xml:"MaintenancePropertySet"`
}

// CreateDescribeMaintenancePropertyRequest creates a request to invoke DescribeMaintenanceProperty API
func CreateDescribeMaintenancePropertyRequest() (request *DescribeMaintenancePropertyRequest) {
	request = &DescribeMaintenancePropertyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeMaintenanceProperty", "ecs", "openAPI")
	return
}

// CreateDescribeMaintenancePropertyResponse creates a response to parse from DescribeMaintenanceProperty response
func CreateDescribeMaintenancePropertyResponse() (response *DescribeMaintenancePropertyResponse) {
	response = &DescribeMaintenancePropertyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
