package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServerlessApplication invokes the edas.DeleteServerlessApplication API synchronously
// api document: https://help.aliyun.com/api/edas/deleteserverlessapplication.html
func (client *Client) DeleteServerlessApplication(request *DeleteServerlessApplicationRequest) (response *DeleteServerlessApplicationResponse, err error) {
	response = CreateDeleteServerlessApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServerlessApplicationWithChan invokes the edas.DeleteServerlessApplication API asynchronously
// api document: https://help.aliyun.com/api/edas/deleteserverlessapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteServerlessApplicationWithChan(request *DeleteServerlessApplicationRequest) (<-chan *DeleteServerlessApplicationResponse, <-chan error) {
	responseChan := make(chan *DeleteServerlessApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServerlessApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServerlessApplicationWithCallback invokes the edas.DeleteServerlessApplication API asynchronously
// api document: https://help.aliyun.com/api/edas/deleteserverlessapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteServerlessApplicationWithCallback(request *DeleteServerlessApplicationRequest, callback func(response *DeleteServerlessApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServerlessApplicationResponse
		var err error
		defer close(result)
		response, err = client.DeleteServerlessApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServerlessApplicationRequest is the request struct for api DeleteServerlessApplication
type DeleteServerlessApplicationRequest struct {
	*requests.RoaRequest
	Act   string `position:"Query" name:"Act"`
	AppId string `position:"Query" name:"AppId"`
}

// DeleteServerlessApplicationResponse is the response struct for api DeleteServerlessApplication
type DeleteServerlessApplicationResponse struct {
	*responses.BaseResponse
	Code          int    `json:"Code" xml:"Code"`
	Message       string `json:"Message" xml:"Message"`
	ChangeOrderId string `json:"ChangeOrderId" xml:"ChangeOrderId"`
}

// CreateDeleteServerlessApplicationRequest creates a request to invoke DeleteServerlessApplication API
func CreateDeleteServerlessApplicationRequest() (request *DeleteServerlessApplicationRequest) {
	request = &DeleteServerlessApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteServerlessApplication", "/pop/v5/k8s/pop/pop_serverless_app_delete", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteServerlessApplicationResponse creates a response to parse from DeleteServerlessApplication response
func CreateDeleteServerlessApplicationResponse() (response *DeleteServerlessApplicationResponse) {
	response = &DeleteServerlessApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
