package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSnapshotReposByInstanceId invokes the elasticsearch.ListSnapshotReposByInstanceId API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/listsnapshotreposbyinstanceid.html
func (client *Client) ListSnapshotReposByInstanceId(request *ListSnapshotReposByInstanceIdRequest) (response *ListSnapshotReposByInstanceIdResponse, err error) {
	response = CreateListSnapshotReposByInstanceIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListSnapshotReposByInstanceIdWithChan invokes the elasticsearch.ListSnapshotReposByInstanceId API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/listsnapshotreposbyinstanceid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSnapshotReposByInstanceIdWithChan(request *ListSnapshotReposByInstanceIdRequest) (<-chan *ListSnapshotReposByInstanceIdResponse, <-chan error) {
	responseChan := make(chan *ListSnapshotReposByInstanceIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSnapshotReposByInstanceId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSnapshotReposByInstanceIdWithCallback invokes the elasticsearch.ListSnapshotReposByInstanceId API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/listsnapshotreposbyinstanceid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSnapshotReposByInstanceIdWithCallback(request *ListSnapshotReposByInstanceIdRequest, callback func(response *ListSnapshotReposByInstanceIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSnapshotReposByInstanceIdResponse
		var err error
		defer close(result)
		response, err = client.ListSnapshotReposByInstanceId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSnapshotReposByInstanceIdRequest is the request struct for api ListSnapshotReposByInstanceId
type ListSnapshotReposByInstanceIdRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListSnapshotReposByInstanceIdResponse is the response struct for api ListSnapshotReposByInstanceId
type ListSnapshotReposByInstanceIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    []Repo `json:"Result" xml:"Result"`
}

// CreateListSnapshotReposByInstanceIdRequest creates a request to invoke ListSnapshotReposByInstanceId API
func CreateListSnapshotReposByInstanceIdRequest() (request *ListSnapshotReposByInstanceIdRequest) {
	request = &ListSnapshotReposByInstanceIdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListSnapshotReposByInstanceId", "/openapi/instances/[InstanceId]/snapshot-repos", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSnapshotReposByInstanceIdResponse creates a response to parse from ListSnapshotReposByInstanceId response
func CreateListSnapshotReposByInstanceIdResponse() (response *ListSnapshotReposByInstanceIdResponse) {
	response = &ListSnapshotReposByInstanceIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
