package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RollbackInstance invokes the elasticsearch.RollbackInstance API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/rollbackinstance.html
func (client *Client) RollbackInstance(request *RollbackInstanceRequest) (response *RollbackInstanceResponse, err error) {
	response = CreateRollbackInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RollbackInstanceWithChan invokes the elasticsearch.RollbackInstance API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/rollbackinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RollbackInstanceWithChan(request *RollbackInstanceRequest) (<-chan *RollbackInstanceResponse, <-chan error) {
	responseChan := make(chan *RollbackInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RollbackInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RollbackInstanceWithCallback invokes the elasticsearch.RollbackInstance API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/rollbackinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RollbackInstanceWithCallback(request *RollbackInstanceRequest, callback func(response *RollbackInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RollbackInstanceResponse
		var err error
		defer close(result)
		response, err = client.RollbackInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RollbackInstanceRequest is the request struct for api RollbackInstance
type RollbackInstanceRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
}

// RollbackInstanceResponse is the response struct for api RollbackInstance
type RollbackInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateRollbackInstanceRequest creates a request to invoke RollbackInstance API
func CreateRollbackInstanceRequest() (request *RollbackInstanceRequest) {
	request = &RollbackInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "RollbackInstance", "/openapi/instances/[InstanceId]/actions/rollback", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRollbackInstanceResponse creates a response to parse from RollbackInstance response
func CreateRollbackInstanceResponse() (response *RollbackInstanceResponse) {
	response = &RollbackInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
