package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneDataSource invokes the emr.CloneDataSource API synchronously
// api document: https://help.aliyun.com/api/emr/clonedatasource.html
func (client *Client) CloneDataSource(request *CloneDataSourceRequest) (response *CloneDataSourceResponse, err error) {
	response = CreateCloneDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CloneDataSourceWithChan invokes the emr.CloneDataSource API asynchronously
// api document: https://help.aliyun.com/api/emr/clonedatasource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloneDataSourceWithChan(request *CloneDataSourceRequest) (<-chan *CloneDataSourceResponse, <-chan error) {
	responseChan := make(chan *CloneDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneDataSourceWithCallback invokes the emr.CloneDataSource API asynchronously
// api document: https://help.aliyun.com/api/emr/clonedatasource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CloneDataSourceWithCallback(request *CloneDataSourceRequest, callback func(response *CloneDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CloneDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneDataSourceRequest is the request struct for api CloneDataSource
type CloneDataSourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Id              string           `position:"Query" name:"Id"`
}

// CloneDataSourceResponse is the response struct for api CloneDataSource
type CloneDataSourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCloneDataSourceRequest creates a request to invoke CloneDataSource API
func CreateCloneDataSourceRequest() (request *CloneDataSourceRequest) {
	request = &CloneDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CloneDataSource", "emr", "openAPI")
	return
}

// CreateCloneDataSourceResponse creates a response to parse from CloneDataSource response
func CreateCloneDataSourceResponse() (response *CloneDataSourceResponse) {
	response = &CloneDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
