package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterWithTemplate invokes the emr.CreateClusterWithTemplate API synchronously
// api document: https://help.aliyun.com/api/emr/createclusterwithtemplate.html
func (client *Client) CreateClusterWithTemplate(request *CreateClusterWithTemplateRequest) (response *CreateClusterWithTemplateResponse, err error) {
	response = CreateCreateClusterWithTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterWithTemplateWithChan invokes the emr.CreateClusterWithTemplate API asynchronously
// api document: https://help.aliyun.com/api/emr/createclusterwithtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateClusterWithTemplateWithChan(request *CreateClusterWithTemplateRequest) (<-chan *CreateClusterWithTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateClusterWithTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterWithTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterWithTemplateWithCallback invokes the emr.CreateClusterWithTemplate API asynchronously
// api document: https://help.aliyun.com/api/emr/createclusterwithtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateClusterWithTemplateWithCallback(request *CreateClusterWithTemplateRequest, callback func(response *CreateClusterWithTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterWithTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateClusterWithTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterWithTemplateRequest is the request struct for api CreateClusterWithTemplate
type CreateClusterWithTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UniqueTag       string           `position:"Query" name:"UniqueTag"`
	ClusterName     string           `position:"Query" name:"ClusterName"`
	TemplateBizId   string           `position:"Query" name:"TemplateBizId"`
}

// CreateClusterWithTemplateResponse is the response struct for api CreateClusterWithTemplate
type CreateClusterWithTemplateResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ClusterId     string `json:"ClusterId" xml:"ClusterId"`
	EmrOrderId    string `json:"EmrOrderId" xml:"EmrOrderId"`
	MasterOrderId string `json:"MasterOrderId" xml:"MasterOrderId"`
	CoreOrderId   string `json:"CoreOrderId" xml:"CoreOrderId"`
}

// CreateCreateClusterWithTemplateRequest creates a request to invoke CreateClusterWithTemplate API
func CreateCreateClusterWithTemplateRequest() (request *CreateClusterWithTemplateRequest) {
	request = &CreateClusterWithTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateClusterWithTemplate", "emr", "openAPI")
	return
}

// CreateCreateClusterWithTemplateResponse creates a response to parse from CreateClusterWithTemplate response
func CreateCreateClusterWithTemplateResponse() (response *CreateClusterWithTemplateResponse) {
	response = &CreateClusterWithTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
