package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKafkaReassign invokes the emr.DescribeKafkaReassign API synchronously
// api document: https://help.aliyun.com/api/emr/describekafkareassign.html
func (client *Client) DescribeKafkaReassign(request *DescribeKafkaReassignRequest) (response *DescribeKafkaReassignResponse, err error) {
	response = CreateDescribeKafkaReassignResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKafkaReassignWithChan invokes the emr.DescribeKafkaReassign API asynchronously
// api document: https://help.aliyun.com/api/emr/describekafkareassign.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeKafkaReassignWithChan(request *DescribeKafkaReassignRequest) (<-chan *DescribeKafkaReassignResponse, <-chan error) {
	responseChan := make(chan *DescribeKafkaReassignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKafkaReassign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKafkaReassignWithCallback invokes the emr.DescribeKafkaReassign API asynchronously
// api document: https://help.aliyun.com/api/emr/describekafkareassign.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeKafkaReassignWithCallback(request *DescribeKafkaReassignRequest, callback func(response *DescribeKafkaReassignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKafkaReassignResponse
		var err error
		defer close(result)
		response, err = client.DescribeKafkaReassign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKafkaReassignRequest is the request struct for api DescribeKafkaReassign
type DescribeKafkaReassignRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReassignId      string           `position:"Query" name:"ReassignId"`
}

// DescribeKafkaReassignResponse is the response struct for api DescribeKafkaReassign
type DescribeKafkaReassignResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Id             string `json:"Id" xml:"Id"`
	Status         string `json:"Status" xml:"Status"`
	AssignProcess  int    `json:"AssignProcess" xml:"AssignProcess"`
	StartTime      int64  `json:"StartTime" xml:"StartTime"`
	EndTime        int64  `json:"EndTime" xml:"EndTime"`
	TopicCount     int    `json:"TopicCount" xml:"TopicCount"`
	PartitionCount int    `json:"PartitionCount" xml:"PartitionCount"`
	Throttle       int64  `json:"Throttle" xml:"Throttle"`
}

// CreateDescribeKafkaReassignRequest creates a request to invoke DescribeKafkaReassign API
func CreateDescribeKafkaReassignRequest() (request *DescribeKafkaReassignRequest) {
	request = &DescribeKafkaReassignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeKafkaReassign", "emr", "openAPI")
	return
}

// CreateDescribeKafkaReassignResponse creates a response to parse from DescribeKafkaReassign response
func CreateDescribeKafkaReassignResponse() (response *DescribeKafkaReassignResponse) {
	response = &DescribeKafkaReassignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
