package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNote invokes the emr.DescribeNote API synchronously
// api document: https://help.aliyun.com/api/emr/describenote.html
func (client *Client) DescribeNote(request *DescribeNoteRequest) (response *DescribeNoteResponse, err error) {
	response = CreateDescribeNoteResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNoteWithChan invokes the emr.DescribeNote API asynchronously
// api document: https://help.aliyun.com/api/emr/describenote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNoteWithChan(request *DescribeNoteRequest) (<-chan *DescribeNoteResponse, <-chan error) {
	responseChan := make(chan *DescribeNoteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNote(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNoteWithCallback invokes the emr.DescribeNote API asynchronously
// api document: https://help.aliyun.com/api/emr/describenote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNoteWithCallback(request *DescribeNoteRequest, callback func(response *DescribeNoteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNoteResponse
		var err error
		defer close(result)
		response, err = client.DescribeNote(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNoteRequest is the request struct for api DescribeNote
type DescribeNoteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// DescribeNoteResponse is the response struct for api DescribeNote
type DescribeNoteResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Id         string `json:"Id" xml:"Id"`
	Name       string `json:"Name" xml:"Name"`
	ClusterId  string `json:"ClusterId" xml:"ClusterId"`
	Type       string `json:"Type" xml:"Type"`
	Paragraphs string `json:"Paragraphs" xml:"Paragraphs"`
}

// CreateDescribeNoteRequest creates a request to invoke DescribeNote API
func CreateDescribeNoteRequest() (request *DescribeNoteRequest) {
	request = &DescribeNoteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeNote", "emr", "openAPI")
	return
}

// CreateDescribeNoteResponse creates a response to parse from DescribeNote response
func CreateDescribeNoteResponse() (response *DescribeNoteResponse) {
	response = &DescribeNoteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
