package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBackInfo invokes the emr.GetBackInfo API synchronously
// api document: https://help.aliyun.com/api/emr/getbackinfo.html
func (client *Client) GetBackInfo(request *GetBackInfoRequest) (response *GetBackInfoResponse, err error) {
	response = CreateGetBackInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetBackInfoWithChan invokes the emr.GetBackInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getbackinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBackInfoWithChan(request *GetBackInfoRequest) (<-chan *GetBackInfoResponse, <-chan error) {
	responseChan := make(chan *GetBackInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBackInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBackInfoWithCallback invokes the emr.GetBackInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getbackinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBackInfoWithCallback(request *GetBackInfoRequest, callback func(response *GetBackInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBackInfoResponse
		var err error
		defer close(result)
		response, err = client.GetBackInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBackInfoRequest is the request struct for api GetBackInfo
type GetBackInfoRequest struct {
	*requests.RpcRequest
}

// GetBackInfoResponse is the response struct for api GetBackInfo
type GetBackInfoResponse struct {
	*responses.BaseResponse
	Paging       bool         `json:"Paging" xml:"Paging"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Id           string       `json:"Id" xml:"Id"`
	BackupPlanId string       `json:"BackupPlanId" xml:"BackupPlanId"`
	ClusterId    string       `json:"ClusterId" xml:"ClusterId"`
	CreateTime   int64        `json:"CreateTime" xml:"CreateTime"`
	Md5          string       `json:"Md5" xml:"Md5"`
	TarFileName  string       `json:"TarFileName" xml:"TarFileName"`
	StorePath    string       `json:"StorePath" xml:"StorePath"`
	Status       string       `json:"Status" xml:"Status"`
	MetadataInfo MetadataInfo `json:"MetadataInfo" xml:"MetadataInfo"`
}

// CreateGetBackInfoRequest creates a request to invoke GetBackInfo API
func CreateGetBackInfoRequest() (request *GetBackInfoRequest) {
	request = &GetBackInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetBackInfo", "emr", "openAPI")
	return
}

// CreateGetBackInfoResponse creates a response to parse from GetBackInfo response
func CreateGetBackInfoResponse() (response *GetBackInfoResponse) {
	response = &GetBackInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
