package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobRunningTimeStatisticInfo invokes the emr.GetJobRunningTimeStatisticInfo API synchronously
// api document: https://help.aliyun.com/api/emr/getjobrunningtimestatisticinfo.html
func (client *Client) GetJobRunningTimeStatisticInfo(request *GetJobRunningTimeStatisticInfoRequest) (response *GetJobRunningTimeStatisticInfoResponse, err error) {
	response = CreateGetJobRunningTimeStatisticInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobRunningTimeStatisticInfoWithChan invokes the emr.GetJobRunningTimeStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getjobrunningtimestatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobRunningTimeStatisticInfoWithChan(request *GetJobRunningTimeStatisticInfoRequest) (<-chan *GetJobRunningTimeStatisticInfoResponse, <-chan error) {
	responseChan := make(chan *GetJobRunningTimeStatisticInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobRunningTimeStatisticInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobRunningTimeStatisticInfoWithCallback invokes the emr.GetJobRunningTimeStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/getjobrunningtimestatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobRunningTimeStatisticInfoWithCallback(request *GetJobRunningTimeStatisticInfoRequest, callback func(response *GetJobRunningTimeStatisticInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobRunningTimeStatisticInfoResponse
		var err error
		defer close(result)
		response, err = client.GetJobRunningTimeStatisticInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobRunningTimeStatisticInfoRequest is the request struct for api GetJobRunningTimeStatisticInfo
type GetJobRunningTimeStatisticInfoRequest struct {
	*requests.RpcRequest
	FromDatetime    string           `position:"Query" name:"FromDatetime"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ToDatetime      string           `position:"Query" name:"ToDatetime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// GetJobRunningTimeStatisticInfoResponse is the response struct for api GetJobRunningTimeStatisticInfo
type GetJobRunningTimeStatisticInfoResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Total           int             `json:"Total" xml:"Total"`
	PageNumber      int             `json:"PageNumber" xml:"PageNumber"`
	PageSize        int             `json:"PageSize" xml:"PageSize"`
	RunningTimeList RunningTimeList `json:"RunningTimeList" xml:"RunningTimeList"`
}

// CreateGetJobRunningTimeStatisticInfoRequest creates a request to invoke GetJobRunningTimeStatisticInfo API
func CreateGetJobRunningTimeStatisticInfoRequest() (request *GetJobRunningTimeStatisticInfoRequest) {
	request = &GetJobRunningTimeStatisticInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetJobRunningTimeStatisticInfo", "emr", "openAPI")
	return
}

// CreateGetJobRunningTimeStatisticInfoResponse creates a response to parse from GetJobRunningTimeStatisticInfo response
func CreateGetJobRunningTimeStatisticInfoResponse() (response *GetJobRunningTimeStatisticInfoResponse) {
	response = &GetJobRunningTimeStatisticInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
