package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterHostComponent invokes the emr.ListClusterHostComponent API synchronously
// api document: https://help.aliyun.com/api/emr/listclusterhostcomponent.html
func (client *Client) ListClusterHostComponent(request *ListClusterHostComponentRequest) (response *ListClusterHostComponentResponse, err error) {
	response = CreateListClusterHostComponentResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterHostComponentWithChan invokes the emr.ListClusterHostComponent API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterhostcomponent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterHostComponentWithChan(request *ListClusterHostComponentRequest) (<-chan *ListClusterHostComponentResponse, <-chan error) {
	responseChan := make(chan *ListClusterHostComponentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterHostComponent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterHostComponentWithCallback invokes the emr.ListClusterHostComponent API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusterhostcomponent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterHostComponentWithCallback(request *ListClusterHostComponentRequest, callback func(response *ListClusterHostComponentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterHostComponentResponse
		var err error
		defer close(result)
		response, err = client.ListClusterHostComponent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterHostComponentRequest is the request struct for api ListClusterHostComponent
type ListClusterHostComponentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostName        string           `position:"Query" name:"HostName"`
	HostInstanceId  string           `position:"Query" name:"HostInstanceId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ComponentName   string           `position:"Query" name:"ComponentName"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	HostRole        string           `position:"Query" name:"HostRole"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ComponentStatus string           `position:"Query" name:"ComponentStatus"`
}

// ListClusterHostComponentResponse is the response struct for api ListClusterHostComponent
type ListClusterHostComponentResponse struct {
	*responses.BaseResponse
	RequestId     string                                  `json:"RequestId" xml:"RequestId"`
	PageNumber    int                                     `json:"PageNumber" xml:"PageNumber"`
	PageSize      int                                     `json:"PageSize" xml:"PageSize"`
	Total         int                                     `json:"Total" xml:"Total"`
	ComponentList ComponentListInListClusterHostComponent `json:"ComponentList" xml:"ComponentList"`
}

// CreateListClusterHostComponentRequest creates a request to invoke ListClusterHostComponent API
func CreateListClusterHostComponentRequest() (request *ListClusterHostComponentRequest) {
	request = &ListClusterHostComponentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterHostComponent", "emr", "openAPI")
	return
}

// CreateListClusterHostComponentResponse creates a response to parse from ListClusterHostComponent response
func CreateListClusterHostComponentResponse() (response *ListClusterHostComponentResponse) {
	response = &ListClusterHostComponentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
