package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterSupportService invokes the emr.ListClusterSupportService API synchronously
// api document: https://help.aliyun.com/api/emr/listclustersupportservice.html
func (client *Client) ListClusterSupportService(request *ListClusterSupportServiceRequest) (response *ListClusterSupportServiceResponse, err error) {
	response = CreateListClusterSupportServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterSupportServiceWithChan invokes the emr.ListClusterSupportService API asynchronously
// api document: https://help.aliyun.com/api/emr/listclustersupportservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterSupportServiceWithChan(request *ListClusterSupportServiceRequest) (<-chan *ListClusterSupportServiceResponse, <-chan error) {
	responseChan := make(chan *ListClusterSupportServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterSupportService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterSupportServiceWithCallback invokes the emr.ListClusterSupportService API asynchronously
// api document: https://help.aliyun.com/api/emr/listclustersupportservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterSupportServiceWithCallback(request *ListClusterSupportServiceRequest, callback func(response *ListClusterSupportServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterSupportServiceResponse
		var err error
		defer close(result)
		response, err = client.ListClusterSupportService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterSupportServiceRequest is the request struct for api ListClusterSupportService
type ListClusterSupportServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// ListClusterSupportServiceResponse is the response struct for api ListClusterSupportService
type ListClusterSupportServiceResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	TotalCount         string             `json:"TotalCount" xml:"TotalCount"`
	PageNumber         string             `json:"PageNumber" xml:"PageNumber"`
	SupportServiceList SupportServiceList `json:"SupportServiceList" xml:"SupportServiceList"`
}

// CreateListClusterSupportServiceRequest creates a request to invoke ListClusterSupportService API
func CreateListClusterSupportServiceRequest() (request *ListClusterSupportServiceRequest) {
	request = &ListClusterSupportServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterSupportService", "emr", "openAPI")
	return
}

// CreateListClusterSupportServiceResponse creates a response to parse from ListClusterSupportService response
func CreateListClusterSupportServiceResponse() (response *ListClusterSupportServiceResponse) {
	response = &ListClusterSupportServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
