package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobMigrateInfo invokes the emr.ListJobMigrateInfo API synchronously
// api document: https://help.aliyun.com/api/emr/listjobmigrateinfo.html
func (client *Client) ListJobMigrateInfo(request *ListJobMigrateInfoRequest) (response *ListJobMigrateInfoResponse, err error) {
	response = CreateListJobMigrateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobMigrateInfoWithChan invokes the emr.ListJobMigrateInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobmigrateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobMigrateInfoWithChan(request *ListJobMigrateInfoRequest) (<-chan *ListJobMigrateInfoResponse, <-chan error) {
	responseChan := make(chan *ListJobMigrateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobMigrateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobMigrateInfoWithCallback invokes the emr.ListJobMigrateInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobmigrateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobMigrateInfoWithCallback(request *ListJobMigrateInfoRequest, callback func(response *ListJobMigrateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobMigrateInfoResponse
		var err error
		defer close(result)
		response, err = client.ListJobMigrateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobMigrateInfoRequest is the request struct for api ListJobMigrateInfo
type ListJobMigrateInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	UserId          string           `position:"Query" name:"UserId"`
	CurrentSize     requests.Integer `position:"Query" name:"CurrentSize"`
}

// ListJobMigrateInfoResponse is the response struct for api ListJobMigrateInfo
type ListJobMigrateInfoResponse struct {
	*responses.BaseResponse
	Total              int64            `json:"Total" xml:"Total"`
	JobMigrateInfoList []JobMigrateInfo `json:"JobMigrateInfoList" xml:"JobMigrateInfoList"`
}

// CreateListJobMigrateInfoRequest creates a request to invoke ListJobMigrateInfo API
func CreateListJobMigrateInfoRequest() (request *ListJobMigrateInfoRequest) {
	request = &ListJobMigrateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListJobMigrateInfo", "emr", "openAPI")
	return
}

// CreateListJobMigrateInfoResponse creates a response to parse from ListJobMigrateInfo response
func CreateListJobMigrateInfoResponse() (response *ListJobMigrateInfoResponse) {
	response = &ListJobMigrateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
