package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListKafkaReassignTopic invokes the emr.ListKafkaReassignTopic API synchronously
// api document: https://help.aliyun.com/api/emr/listkafkareassigntopic.html
func (client *Client) ListKafkaReassignTopic(request *ListKafkaReassignTopicRequest) (response *ListKafkaReassignTopicResponse, err error) {
	response = CreateListKafkaReassignTopicResponse()
	err = client.DoAction(request, response)
	return
}

// ListKafkaReassignTopicWithChan invokes the emr.ListKafkaReassignTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/listkafkareassigntopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListKafkaReassignTopicWithChan(request *ListKafkaReassignTopicRequest) (<-chan *ListKafkaReassignTopicResponse, <-chan error) {
	responseChan := make(chan *ListKafkaReassignTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListKafkaReassignTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListKafkaReassignTopicWithCallback invokes the emr.ListKafkaReassignTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/listkafkareassigntopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListKafkaReassignTopicWithCallback(request *ListKafkaReassignTopicRequest, callback func(response *ListKafkaReassignTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListKafkaReassignTopicResponse
		var err error
		defer close(result)
		response, err = client.ListKafkaReassignTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListKafkaReassignTopicRequest is the request struct for api ListKafkaReassignTopic
type ListKafkaReassignTopicRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReassignId      string           `position:"Query" name:"ReassignId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListKafkaReassignTopicResponse is the response struct for api ListKafkaReassignTopic
type ListKafkaReassignTopicResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Total             int               `json:"Total" xml:"Total"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	PageNumber        int               `json:"PageNumber" xml:"PageNumber"`
	ReassignTopicList ReassignTopicList `json:"ReassignTopicList" xml:"ReassignTopicList"`
}

// CreateListKafkaReassignTopicRequest creates a request to invoke ListKafkaReassignTopic API
func CreateListKafkaReassignTopicRequest() (request *ListKafkaReassignTopicRequest) {
	request = &ListKafkaReassignTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListKafkaReassignTopic", "emr", "openAPI")
	return
}

// CreateListKafkaReassignTopicResponse creates a response to parse from ListKafkaReassignTopic response
func CreateListKafkaReassignTopicResponse() (response *ListKafkaReassignTopicResponse) {
	response = &ListKafkaReassignTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
