package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceQueue invokes the emr.ListResourceQueue API synchronously
// api document: https://help.aliyun.com/api/emr/listresourcequeue.html
func (client *Client) ListResourceQueue(request *ListResourceQueueRequest) (response *ListResourceQueueResponse, err error) {
	response = CreateListResourceQueueResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceQueueWithChan invokes the emr.ListResourceQueue API asynchronously
// api document: https://help.aliyun.com/api/emr/listresourcequeue.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListResourceQueueWithChan(request *ListResourceQueueRequest) (<-chan *ListResourceQueueResponse, <-chan error) {
	responseChan := make(chan *ListResourceQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceQueueWithCallback invokes the emr.ListResourceQueue API asynchronously
// api document: https://help.aliyun.com/api/emr/listresourcequeue.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListResourceQueueWithCallback(request *ListResourceQueueRequest, callback func(response *ListResourceQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceQueueResponse
		var err error
		defer close(result)
		response, err = client.ListResourceQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceQueueRequest is the request struct for api ListResourceQueue
type ListResourceQueueRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PoolId          requests.Integer `position:"Query" name:"PoolId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PoolType        string           `position:"Query" name:"PoolType"`
}

// ListResourceQueueResponse is the response struct for api ListResourceQueue
type ListResourceQueueResponse struct {
	*responses.BaseResponse
	QueueList QueueListInListResourceQueue `json:"QueueList" xml:"QueueList"`
}

// CreateListResourceQueueRequest creates a request to invoke ListResourceQueue API
func CreateListResourceQueueRequest() (request *ListResourceQueueRequest) {
	request = &ListResourceQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListResourceQueue", "emr", "openAPI")
	return
}

// CreateListResourceQueueResponse creates a response to parse from ListResourceQueue response
func CreateListResourceQueueResponse() (response *ListResourceQueueResponse) {
	response = &ListResourceQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
