package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStackService invokes the emr.ListStackService API synchronously
// api document: https://help.aliyun.com/api/emr/liststackservice.html
func (client *Client) ListStackService(request *ListStackServiceRequest) (response *ListStackServiceResponse, err error) {
	response = CreateListStackServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ListStackServiceWithChan invokes the emr.ListStackService API asynchronously
// api document: https://help.aliyun.com/api/emr/liststackservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStackServiceWithChan(request *ListStackServiceRequest) (<-chan *ListStackServiceResponse, <-chan error) {
	responseChan := make(chan *ListStackServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStackService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStackServiceWithCallback invokes the emr.ListStackService API asynchronously
// api document: https://help.aliyun.com/api/emr/liststackservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStackServiceWithCallback(request *ListStackServiceRequest, callback func(response *ListStackServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStackServiceResponse
		var err error
		defer close(result)
		response, err = client.ListStackService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStackServiceRequest is the request struct for api ListStackService
type ListStackServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StackName       string           `position:"Query" name:"StackName"`
	StackVersion    string           `position:"Query" name:"StackVersion"`
}

// ListStackServiceResponse is the response struct for api ListStackService
type ListStackServiceResponse struct {
	*responses.BaseResponse
	RequestId    string                        `json:"RequestId" xml:"RequestId"`
	StackName    string                        `json:"StackName" xml:"StackName"`
	StackVersion string                        `json:"StackVersion" xml:"StackVersion"`
	ServiceList  ServiceListInListStackService `json:"ServiceList" xml:"ServiceList"`
}

// CreateListStackServiceRequest creates a request to invoke ListStackService API
func CreateListStackServiceRequest() (request *ListStackServiceRequest) {
	request = &ListStackServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListStackService", "emr", "openAPI")
	return
}

// CreateListStackServiceResponse creates a response to parse from ListStackService response
func CreateListStackServiceResponse() (response *ListStackServiceResponse) {
	response = &ListStackServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
