package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSupportedServiceNameForAdmin invokes the emr.ListSupportedServiceNameForAdmin API synchronously
// api document: https://help.aliyun.com/api/emr/listsupportedservicenameforadmin.html
func (client *Client) ListSupportedServiceNameForAdmin(request *ListSupportedServiceNameForAdminRequest) (response *ListSupportedServiceNameForAdminResponse, err error) {
	response = CreateListSupportedServiceNameForAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ListSupportedServiceNameForAdminWithChan invokes the emr.ListSupportedServiceNameForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listsupportedservicenameforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSupportedServiceNameForAdminWithChan(request *ListSupportedServiceNameForAdminRequest) (<-chan *ListSupportedServiceNameForAdminResponse, <-chan error) {
	responseChan := make(chan *ListSupportedServiceNameForAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSupportedServiceNameForAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSupportedServiceNameForAdminWithCallback invokes the emr.ListSupportedServiceNameForAdmin API asynchronously
// api document: https://help.aliyun.com/api/emr/listsupportedservicenameforadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListSupportedServiceNameForAdminWithCallback(request *ListSupportedServiceNameForAdminRequest, callback func(response *ListSupportedServiceNameForAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSupportedServiceNameForAdminResponse
		var err error
		defer close(result)
		response, err = client.ListSupportedServiceNameForAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSupportedServiceNameForAdminRequest is the request struct for api ListSupportedServiceNameForAdmin
type ListSupportedServiceNameForAdminRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UserId          string           `position:"Query" name:"UserId"`
}

// ListSupportedServiceNameForAdminResponse is the response struct for api ListSupportedServiceNameForAdmin
type ListSupportedServiceNameForAdminResponse struct {
	*responses.BaseResponse
	RequestId                string                                                     `json:"RequestId" xml:"RequestId"`
	SupportedServiceNameList SupportedServiceNameListInListSupportedServiceNameForAdmin `json:"SupportedServiceNameList" xml:"SupportedServiceNameList"`
}

// CreateListSupportedServiceNameForAdminRequest creates a request to invoke ListSupportedServiceNameForAdmin API
func CreateListSupportedServiceNameForAdminRequest() (request *ListSupportedServiceNameForAdminRequest) {
	request = &ListSupportedServiceNameForAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListSupportedServiceNameForAdmin", "emr", "openAPI")
	return
}

// CreateListSupportedServiceNameForAdminResponse creates a response to parse from ListSupportedServiceNameForAdmin response
func CreateListSupportedServiceNameForAdminResponse() (response *ListSupportedServiceNameForAdminResponse) {
	response = &ListSupportedServiceNameForAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
