package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHpHost invokes the emr.ModifyHpHost API synchronously
// api document: https://help.aliyun.com/api/emr/modifyhphost.html
func (client *Client) ModifyHpHost(request *ModifyHpHostRequest) (response *ModifyHpHostResponse, err error) {
	response = CreateModifyHpHostResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHpHostWithChan invokes the emr.ModifyHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyhphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHpHostWithChan(request *ModifyHpHostRequest) (<-chan *ModifyHpHostResponse, <-chan error) {
	responseChan := make(chan *ModifyHpHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHpHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHpHostWithCallback invokes the emr.ModifyHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyhphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHpHostWithCallback(request *ModifyHpHostRequest, callback func(response *ModifyHpHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHpHostResponse
		var err error
		defer close(result)
		response, err = client.ModifyHpHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHpHostRequest is the request struct for api ModifyHpHost
type ModifyHpHostRequest struct {
	*requests.RpcRequest
	CpuCore         requests.Integer          `position:"Query" name:"CpuCore"`
	MemSize         requests.Integer          `position:"Query" name:"MemSize"`
	ResourceOwnerId requests.Integer          `position:"Query" name:"ResourceOwnerId"`
	RackInfo        string                    `position:"Query" name:"RackInfo"`
	Role            string                    `position:"Query" name:"Role"`
	SerialNumber    string                    `position:"Query" name:"SerialNumber"`
	HostType        string                    `position:"Query" name:"HostType"`
	SecurityGroupId string                    `position:"Query" name:"SecurityGroupId"`
	HpHostDisk      *[]ModifyHpHostHpHostDisk `position:"Query" name:"HpHostDisk"  type:"Repeated"`
	VswitchId       string                    `position:"Query" name:"VswitchId"`
	HpHostBizId     string                    `position:"Query" name:"HpHostBizId"`
	ExternalKey     string                    `position:"Query" name:"ExternalKey"`
	HostName        string                    `position:"Query" name:"HostName"`
	VpcId           string                    `position:"Query" name:"VpcId"`
	InnerIp         string                    `position:"Query" name:"InnerIp"`
	ExternalIp      string                    `position:"Query" name:"ExternalIp"`
}

// ModifyHpHostHpHostDisk is a repeated param struct in ModifyHpHostRequest
type ModifyHpHostHpHostDisk struct {
	DiskSize   string `name:"DiskSize"`
	MountPath  string `name:"MountPath"`
	DiskDevice string `name:"DiskDevice"`
}

// ModifyHpHostResponse is the response struct for api ModifyHpHost
type ModifyHpHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	BizId     string `json:"BizId" xml:"BizId"`
}

// CreateModifyHpHostRequest creates a request to invoke ModifyHpHost API
func CreateModifyHpHostRequest() (request *ModifyHpHostRequest) {
	request = &ModifyHpHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyHpHost", "emr", "openAPI")
	return
}

// CreateModifyHpHostResponse creates a response to parse from ModifyHpHost response
func CreateModifyHpHostResponse() (response *ModifyHpHostResponse) {
	response = &ModifyHpHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
