package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageListUserGroups invokes the emr.PageListUserGroups API synchronously
// api document: https://help.aliyun.com/api/emr/pagelistusergroups.html
func (client *Client) PageListUserGroups(request *PageListUserGroupsRequest) (response *PageListUserGroupsResponse, err error) {
	response = CreatePageListUserGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// PageListUserGroupsWithChan invokes the emr.PageListUserGroups API asynchronously
// api document: https://help.aliyun.com/api/emr/pagelistusergroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PageListUserGroupsWithChan(request *PageListUserGroupsRequest) (<-chan *PageListUserGroupsResponse, <-chan error) {
	responseChan := make(chan *PageListUserGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageListUserGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageListUserGroupsWithCallback invokes the emr.PageListUserGroups API asynchronously
// api document: https://help.aliyun.com/api/emr/pagelistusergroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PageListUserGroupsWithCallback(request *PageListUserGroupsRequest, callback func(response *PageListUserGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageListUserGroupsResponse
		var err error
		defer close(result)
		response, err = client.PageListUserGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageListUserGroupsRequest is the request struct for api PageListUserGroups
type PageListUserGroupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FuzzyName       string           `position:"Query" name:"FuzzyName"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// PageListUserGroupsResponse is the response struct for api PageListUserGroups
type PageListUserGroupsResponse struct {
	*responses.BaseResponse
	Paging     bool                      `json:"Paging" xml:"Paging"`
	RequestId  string                    `json:"RequestId" xml:"RequestId"`
	PageNumber int                       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                       `json:"PageSize" xml:"PageSize"`
	TotalCount int                       `json:"TotalCount" xml:"TotalCount"`
	Items      ItemsInPageListUserGroups `json:"Items" xml:"Items"`
}

// CreatePageListUserGroupsRequest creates a request to invoke PageListUserGroups API
func CreatePageListUserGroupsRequest() (request *PageListUserGroupsRequest) {
	request = &PageListUserGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "PageListUserGroups", "emr", "openAPI")
	return
}

// CreatePageListUserGroupsResponse creates a response to parse from PageListUserGroups response
func CreatePageListUserGroupsResponse() (response *PageListUserGroupsResponse) {
	response = &PageListUserGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
