package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveHpHost invokes the emr.RemoveHpHost API synchronously
// api document: https://help.aliyun.com/api/emr/removehphost.html
func (client *Client) RemoveHpHost(request *RemoveHpHostRequest) (response *RemoveHpHostResponse, err error) {
	response = CreateRemoveHpHostResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveHpHostWithChan invokes the emr.RemoveHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/removehphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveHpHostWithChan(request *RemoveHpHostRequest) (<-chan *RemoveHpHostResponse, <-chan error) {
	responseChan := make(chan *RemoveHpHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveHpHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveHpHostWithCallback invokes the emr.RemoveHpHost API asynchronously
// api document: https://help.aliyun.com/api/emr/removehphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveHpHostWithCallback(request *RemoveHpHostRequest, callback func(response *RemoveHpHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveHpHostResponse
		var err error
		defer close(result)
		response, err = client.RemoveHpHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveHpHostRequest is the request struct for api RemoveHpHost
type RemoveHpHostRequest struct {
	*requests.RpcRequest
	HpHostBizId     string           `position:"Query" name:"HpHostBizId"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// RemoveHpHostResponse is the response struct for api RemoveHpHost
type RemoveHpHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveHpHostRequest creates a request to invoke RemoveHpHost API
func CreateRemoveHpHostRequest() (request *RemoveHpHostRequest) {
	request = &RemoveHpHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RemoveHpHost", "emr", "openAPI")
	return
}

// CreateRemoveHpHostResponse creates a response to parse from RemoveHpHost response
func CreateRemoveHpHostResponse() (response *RemoveHpHostResponse) {
	response = &RemoveHpHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
