package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResizeClusterWithHostPool invokes the emr.ResizeClusterWithHostPool API synchronously
// api document: https://help.aliyun.com/api/emr/resizeclusterwithhostpool.html
func (client *Client) ResizeClusterWithHostPool(request *ResizeClusterWithHostPoolRequest) (response *ResizeClusterWithHostPoolResponse, err error) {
	response = CreateResizeClusterWithHostPoolResponse()
	err = client.DoAction(request, response)
	return
}

// ResizeClusterWithHostPoolWithChan invokes the emr.ResizeClusterWithHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/resizeclusterwithhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResizeClusterWithHostPoolWithChan(request *ResizeClusterWithHostPoolRequest) (<-chan *ResizeClusterWithHostPoolResponse, <-chan error) {
	responseChan := make(chan *ResizeClusterWithHostPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResizeClusterWithHostPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResizeClusterWithHostPoolWithCallback invokes the emr.ResizeClusterWithHostPool API asynchronously
// api document: https://help.aliyun.com/api/emr/resizeclusterwithhostpool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResizeClusterWithHostPoolWithCallback(request *ResizeClusterWithHostPoolRequest, callback func(response *ResizeClusterWithHostPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResizeClusterWithHostPoolResponse
		var err error
		defer close(result)
		response, err = client.ResizeClusterWithHostPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResizeClusterWithHostPoolRequest is the request struct for api ResizeClusterWithHostPool
type ResizeClusterWithHostPoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	HostGroup       *[]ResizeClusterWithHostPoolHostGroup `position:"Query" name:"HostGroup"  type:"Repeated"`
	HostInfo        *[]ResizeClusterWithHostPoolHostInfo  `position:"Query" name:"HostInfo"  type:"Repeated"`
	ClusterId       string                                `position:"Query" name:"clusterId"`
}

// ResizeClusterWithHostPoolHostGroup is a repeated param struct in ResizeClusterWithHostPoolRequest
type ResizeClusterWithHostPoolHostGroup struct {
	GroupType string `name:"GroupType"`
	GroupId   string `name:"GroupId"`
	GroupName string `name:"GroupName"`
}

// ResizeClusterWithHostPoolHostInfo is a repeated param struct in ResizeClusterWithHostPoolRequest
type ResizeClusterWithHostPoolHostInfo struct {
	HpHostBizId          string                                           `name:"HpHostBizId"`
	HostName             string                                           `name:"HostName"`
	Role                 string                                           `name:"Role"`
	GroupId              string                                           `name:"GroupId"`
	PrivateIp            string                                           `name:"PrivateIp"`
	ServiceComponentInfo *[]ResizeClusterWithHostPoolServiceComponentInfo `name:"ServiceComponentInfo" type:"Repeated"`
	HostGroupName        string                                           `name:"HostGroupName"`
	HostGroupType        string                                           `name:"HostGroupType"`
}

// ResizeClusterWithHostPoolServiceComponentInfo is a repeated param struct in ResizeClusterWithHostPoolRequest
type ResizeClusterWithHostPoolServiceComponentInfo struct {
	ServiceEcmVersion string `name:"serviceEcmVersion"`
	ComponentName     string `name:"ComponentName"`
	ServiceName       string `name:"ServiceName"`
}

// ResizeClusterWithHostPoolResponse is the response struct for api ResizeClusterWithHostPool
type ResizeClusterWithHostPoolResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ClusterId          string `json:"ClusterId" xml:"ClusterId"`
	WorkFlowInstanceId string `json:"WorkFlowInstanceId" xml:"WorkFlowInstanceId"`
	OperationId        string `json:"OperationId" xml:"OperationId"`
}

// CreateResizeClusterWithHostPoolRequest creates a request to invoke ResizeClusterWithHostPool API
func CreateResizeClusterWithHostPoolRequest() (request *ResizeClusterWithHostPoolRequest) {
	request = &ResizeClusterWithHostPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ResizeClusterWithHostPool", "emr", "openAPI")
	return
}

// CreateResizeClusterWithHostPoolResponse creates a response to parse from ResizeClusterWithHostPool response
func CreateResizeClusterWithHostPoolResponse() (response *ResizeClusterWithHostPoolResponse) {
	response = &ResizeClusterWithHostPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
