package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveBatchUserAccountInfo invokes the emr.SaveBatchUserAccountInfo API synchronously
// api document: https://help.aliyun.com/api/emr/savebatchuseraccountinfo.html
func (client *Client) SaveBatchUserAccountInfo(request *SaveBatchUserAccountInfoRequest) (response *SaveBatchUserAccountInfoResponse, err error) {
	response = CreateSaveBatchUserAccountInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SaveBatchUserAccountInfoWithChan invokes the emr.SaveBatchUserAccountInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/savebatchuseraccountinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveBatchUserAccountInfoWithChan(request *SaveBatchUserAccountInfoRequest) (<-chan *SaveBatchUserAccountInfoResponse, <-chan error) {
	responseChan := make(chan *SaveBatchUserAccountInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveBatchUserAccountInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveBatchUserAccountInfoWithCallback invokes the emr.SaveBatchUserAccountInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/savebatchuseraccountinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveBatchUserAccountInfoWithCallback(request *SaveBatchUserAccountInfoRequest, callback func(response *SaveBatchUserAccountInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveBatchUserAccountInfoResponse
		var err error
		defer close(result)
		response, err = client.SaveBatchUserAccountInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveBatchUserAccountInfoRequest is the request struct for api SaveBatchUserAccountInfo
type SaveBatchUserAccountInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId       string           `position:"Query" name:"ResourceId"`
	AliyunUserIdList *[]string        `position:"Query" name:"AliyunUserIdList"  type:"Repeated"`
	AccountType      string           `position:"Query" name:"AccountType"`
	GroupName        string           `position:"Query" name:"GroupName"`
	ResourceType     string           `position:"Query" name:"ResourceType"`
	AuthType         string           `position:"Query" name:"AuthType"`
	AccountPassword  string           `position:"Query" name:"AccountPassword"`
}

// SaveBatchUserAccountInfoResponse is the response struct for api SaveBatchUserAccountInfo
type SaveBatchUserAccountInfoResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateSaveBatchUserAccountInfoRequest creates a request to invoke SaveBatchUserAccountInfo API
func CreateSaveBatchUserAccountInfoRequest() (request *SaveBatchUserAccountInfoRequest) {
	request = &SaveBatchUserAccountInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "SaveBatchUserAccountInfo", "emr", "openAPI")
	return
}

// CreateSaveBatchUserAccountInfoResponse creates a response to parse from SaveBatchUserAccountInfo response
func CreateSaveBatchUserAccountInfoResponse() (response *SaveBatchUserAccountInfoResponse) {
	response = &SaveBatchUserAccountInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
