package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartKafkaPreferredReplicaElection invokes the emr.StartKafkaPreferredReplicaElection API synchronously
// api document: https://help.aliyun.com/api/emr/startkafkapreferredreplicaelection.html
func (client *Client) StartKafkaPreferredReplicaElection(request *StartKafkaPreferredReplicaElectionRequest) (response *StartKafkaPreferredReplicaElectionResponse, err error) {
	response = CreateStartKafkaPreferredReplicaElectionResponse()
	err = client.DoAction(request, response)
	return
}

// StartKafkaPreferredReplicaElectionWithChan invokes the emr.StartKafkaPreferredReplicaElection API asynchronously
// api document: https://help.aliyun.com/api/emr/startkafkapreferredreplicaelection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartKafkaPreferredReplicaElectionWithChan(request *StartKafkaPreferredReplicaElectionRequest) (<-chan *StartKafkaPreferredReplicaElectionResponse, <-chan error) {
	responseChan := make(chan *StartKafkaPreferredReplicaElectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartKafkaPreferredReplicaElection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartKafkaPreferredReplicaElectionWithCallback invokes the emr.StartKafkaPreferredReplicaElection API asynchronously
// api document: https://help.aliyun.com/api/emr/startkafkapreferredreplicaelection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartKafkaPreferredReplicaElectionWithCallback(request *StartKafkaPreferredReplicaElectionRequest, callback func(response *StartKafkaPreferredReplicaElectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartKafkaPreferredReplicaElectionResponse
		var err error
		defer close(result)
		response, err = client.StartKafkaPreferredReplicaElection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartKafkaPreferredReplicaElectionRequest is the request struct for api StartKafkaPreferredReplicaElection
type StartKafkaPreferredReplicaElectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TopicId         string           `position:"Query" name:"TopicId"`
}

// StartKafkaPreferredReplicaElectionResponse is the response struct for api StartKafkaPreferredReplicaElection
type StartKafkaPreferredReplicaElectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartKafkaPreferredReplicaElectionRequest creates a request to invoke StartKafkaPreferredReplicaElection API
func CreateStartKafkaPreferredReplicaElectionRequest() (request *StartKafkaPreferredReplicaElectionRequest) {
	request = &StartKafkaPreferredReplicaElectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "StartKafkaPreferredReplicaElection", "emr", "openAPI")
	return
}

// CreateStartKafkaPreferredReplicaElectionResponse creates a response to parse from StartKafkaPreferredReplicaElection response
func CreateStartKafkaPreferredReplicaElectionResponse() (response *StartKafkaPreferredReplicaElectionResponse) {
	response = &StartKafkaPreferredReplicaElectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
