package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUserStatus invokes the emr.UpdateUserStatus API synchronously
// api document: https://help.aliyun.com/api/emr/updateuserstatus.html
func (client *Client) UpdateUserStatus(request *UpdateUserStatusRequest) (response *UpdateUserStatusResponse, err error) {
	response = CreateUpdateUserStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUserStatusWithChan invokes the emr.UpdateUserStatus API asynchronously
// api document: https://help.aliyun.com/api/emr/updateuserstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateUserStatusWithChan(request *UpdateUserStatusRequest) (<-chan *UpdateUserStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateUserStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUserStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUserStatusWithCallback invokes the emr.UpdateUserStatus API asynchronously
// api document: https://help.aliyun.com/api/emr/updateuserstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateUserStatusWithCallback(request *UpdateUserStatusRequest, callback func(response *UpdateUserStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUserStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateUserStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUserStatusRequest is the request struct for api UpdateUserStatus
type UpdateUserStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AliyunUserId    string           `position:"Query" name:"AliyunUserId"`
	UpdateStatus    string           `position:"Query" name:"UpdateStatus"`
}

// UpdateUserStatusResponse is the response struct for api UpdateUserStatus
type UpdateUserStatusResponse struct {
	*responses.BaseResponse
	Paging    bool   `json:"Paging" xml:"Paging"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateUpdateUserStatusRequest creates a request to invoke UpdateUserStatus API
func CreateUpdateUserStatusRequest() (request *UpdateUserStatusRequest) {
	request = &UpdateUserStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateUserStatus", "emr", "openAPI")
	return
}

// CreateUpdateUserStatusResponse creates a response to parse from UpdateUserStatus response
func CreateUpdateUserStatusResponse() (response *UpdateUserStatusResponse) {
	response = &UpdateUserStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
