package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateKeywordLib invokes the green.CreateKeywordLib API synchronously
// api document: https://help.aliyun.com/api/green/createkeywordlib.html
func (client *Client) CreateKeywordLib(request *CreateKeywordLibRequest) (response *CreateKeywordLibResponse, err error) {
	response = CreateCreateKeywordLibResponse()
	err = client.DoAction(request, response)
	return
}

// CreateKeywordLibWithChan invokes the green.CreateKeywordLib API asynchronously
// api document: https://help.aliyun.com/api/green/createkeywordlib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateKeywordLibWithChan(request *CreateKeywordLibRequest) (<-chan *CreateKeywordLibResponse, <-chan error) {
	responseChan := make(chan *CreateKeywordLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateKeywordLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateKeywordLibWithCallback invokes the green.CreateKeywordLib API asynchronously
// api document: https://help.aliyun.com/api/green/createkeywordlib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateKeywordLibWithCallback(request *CreateKeywordLibRequest, callback func(response *CreateKeywordLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateKeywordLibResponse
		var err error
		defer close(result)
		response, err = client.CreateKeywordLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateKeywordLibRequest is the request struct for api CreateKeywordLib
type CreateKeywordLibRequest struct {
	*requests.RpcRequest
	Language      string           `position:"Query" name:"Language"`
	ServiceModule string           `position:"Query" name:"ServiceModule"`
	MatchMode     string           `position:"Query" name:"MatchMode"`
	SourceIp      string           `position:"Query" name:"SourceIp"`
	LibType       string           `position:"Query" name:"LibType"`
	Enable        requests.Boolean `position:"Query" name:"Enable"`
	Lang          string           `position:"Query" name:"Lang"`
	BizTypes      string           `position:"Query" name:"BizTypes"`
	ResourceType  string           `position:"Query" name:"ResourceType"`
	Name          string           `position:"Query" name:"Name"`
	Category      string           `position:"Query" name:"Category"`
}

// CreateKeywordLibResponse is the response struct for api CreateKeywordLib
type CreateKeywordLibResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateKeywordLibRequest creates a request to invoke CreateKeywordLib API
func CreateCreateKeywordLibRequest() (request *CreateKeywordLibRequest) {
	request = &CreateKeywordLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "CreateKeywordLib", "green", "openAPI")
	return
}

// CreateCreateKeywordLibResponse creates a response to parse from CreateKeywordLib response
func CreateCreateKeywordLibResponse() (response *CreateKeywordLibResponse) {
	response = &CreateKeywordLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
