package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuditRange invokes the green.DescribeAuditRange API synchronously
// api document: https://help.aliyun.com/api/green/describeauditrange.html
func (client *Client) DescribeAuditRange(request *DescribeAuditRangeRequest) (response *DescribeAuditRangeResponse, err error) {
	response = CreateDescribeAuditRangeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuditRangeWithChan invokes the green.DescribeAuditRange API asynchronously
// api document: https://help.aliyun.com/api/green/describeauditrange.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuditRangeWithChan(request *DescribeAuditRangeRequest) (<-chan *DescribeAuditRangeResponse, <-chan error) {
	responseChan := make(chan *DescribeAuditRangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuditRange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuditRangeWithCallback invokes the green.DescribeAuditRange API asynchronously
// api document: https://help.aliyun.com/api/green/describeauditrange.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuditRangeWithCallback(request *DescribeAuditRangeRequest, callback func(response *DescribeAuditRangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuditRangeResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuditRange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuditRangeRequest is the request struct for api DescribeAuditRange
type DescribeAuditRangeRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeAuditRangeResponse is the response struct for api DescribeAuditRange
type DescribeAuditRangeResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	AuditRange AuditRange `json:"AuditRange" xml:"AuditRange"`
}

// CreateDescribeAuditRangeRequest creates a request to invoke DescribeAuditRange API
func CreateDescribeAuditRangeRequest() (request *DescribeAuditRangeRequest) {
	request = &DescribeAuditRangeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeAuditRange", "green", "openAPI")
	return
}

// CreateDescribeAuditRangeResponse creates a response to parse from DescribeAuditRange response
func CreateDescribeAuditRangeResponse() (response *DescribeAuditRangeResponse) {
	response = &DescribeAuditRangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
