package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyWebsiteInstance invokes the green.VerifyWebsiteInstance API synchronously
// api document: https://help.aliyun.com/api/green/verifywebsiteinstance.html
func (client *Client) VerifyWebsiteInstance(request *VerifyWebsiteInstanceRequest) (response *VerifyWebsiteInstanceResponse, err error) {
	response = CreateVerifyWebsiteInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyWebsiteInstanceWithChan invokes the green.VerifyWebsiteInstance API asynchronously
// api document: https://help.aliyun.com/api/green/verifywebsiteinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyWebsiteInstanceWithChan(request *VerifyWebsiteInstanceRequest) (<-chan *VerifyWebsiteInstanceResponse, <-chan error) {
	responseChan := make(chan *VerifyWebsiteInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyWebsiteInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyWebsiteInstanceWithCallback invokes the green.VerifyWebsiteInstance API asynchronously
// api document: https://help.aliyun.com/api/green/verifywebsiteinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VerifyWebsiteInstanceWithCallback(request *VerifyWebsiteInstanceRequest, callback func(response *VerifyWebsiteInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyWebsiteInstanceResponse
		var err error
		defer close(result)
		response, err = client.VerifyWebsiteInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyWebsiteInstanceRequest is the request struct for api VerifyWebsiteInstance
type VerifyWebsiteInstanceRequest struct {
	*requests.RpcRequest
	VerifyMethod string `position:"Query" name:"VerifyMethod"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// VerifyWebsiteInstanceResponse is the response struct for api VerifyWebsiteInstance
type VerifyWebsiteInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyWebsiteInstanceRequest creates a request to invoke VerifyWebsiteInstance API
func CreateVerifyWebsiteInstanceRequest() (request *VerifyWebsiteInstanceRequest) {
	request = &VerifyWebsiteInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "VerifyWebsiteInstance", "green", "openAPI")
	return
}

// CreateVerifyWebsiteInstanceResponse creates a response to parse from VerifyWebsiteInstance response
func CreateVerifyWebsiteInstanceResponse() (response *VerifyWebsiteInstanceResponse) {
	response = &VerifyWebsiteInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
