package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteHbaseHaSlb invokes the hbase.DeleteHbaseHaSlb API synchronously
// api document: https://help.aliyun.com/api/hbase/deletehbasehaslb.html
func (client *Client) DeleteHbaseHaSlb(request *DeleteHbaseHaSlbRequest) (response *DeleteHbaseHaSlbResponse, err error) {
	response = CreateDeleteHbaseHaSlbResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteHbaseHaSlbWithChan invokes the hbase.DeleteHbaseHaSlb API asynchronously
// api document: https://help.aliyun.com/api/hbase/deletehbasehaslb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteHbaseHaSlbWithChan(request *DeleteHbaseHaSlbRequest) (<-chan *DeleteHbaseHaSlbResponse, <-chan error) {
	responseChan := make(chan *DeleteHbaseHaSlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteHbaseHaSlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteHbaseHaSlbWithCallback invokes the hbase.DeleteHbaseHaSlb API asynchronously
// api document: https://help.aliyun.com/api/hbase/deletehbasehaslb.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteHbaseHaSlbWithCallback(request *DeleteHbaseHaSlbRequest, callback func(response *DeleteHbaseHaSlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteHbaseHaSlbResponse
		var err error
		defer close(result)
		response, err = client.DeleteHbaseHaSlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteHbaseHaSlbRequest is the request struct for api DeleteHbaseHaSlb
type DeleteHbaseHaSlbRequest struct {
	*requests.RpcRequest
	HaId    string `position:"Query" name:"HaId"`
	HaTypes string `position:"Query" name:"HaTypes"`
	BdsId   string `position:"Query" name:"BdsId"`
}

// DeleteHbaseHaSlbResponse is the response struct for api DeleteHbaseHaSlb
type DeleteHbaseHaSlbResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteHbaseHaSlbRequest creates a request to invoke DeleteHbaseHaSlb API
func CreateDeleteHbaseHaSlbRequest() (request *DeleteHbaseHaSlbRequest) {
	request = &DeleteHbaseHaSlbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DeleteHbaseHaSlb", "hbase", "openAPI")
	return
}

// CreateDeleteHbaseHaSlbResponse creates a response to parse from DeleteHbaseHaSlb response
func CreateDeleteHbaseHaSlbResponse() (response *DeleteHbaseHaSlbResponse) {
	response = &DeleteHbaseHaSlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
