package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectImageTexts invokes the imm.DetectImageTexts API synchronously
// api document: https://help.aliyun.com/api/imm/detectimagetexts.html
func (client *Client) DetectImageTexts(request *DetectImageTextsRequest) (response *DetectImageTextsResponse, err error) {
	response = CreateDetectImageTextsResponse()
	err = client.DoAction(request, response)
	return
}

// DetectImageTextsWithChan invokes the imm.DetectImageTexts API asynchronously
// api document: https://help.aliyun.com/api/imm/detectimagetexts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectImageTextsWithChan(request *DetectImageTextsRequest) (<-chan *DetectImageTextsResponse, <-chan error) {
	responseChan := make(chan *DetectImageTextsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectImageTexts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectImageTextsWithCallback invokes the imm.DetectImageTexts API asynchronously
// api document: https://help.aliyun.com/api/imm/detectimagetexts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectImageTextsWithCallback(request *DetectImageTextsRequest, callback func(response *DetectImageTextsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectImageTextsResponse
		var err error
		defer close(result)
		response, err = client.DetectImageTexts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectImageTextsRequest is the request struct for api DetectImageTexts
type DetectImageTextsRequest struct {
	*requests.RpcRequest
	Project  string `position:"Query" name:"Project"`
	ImageUri string `position:"Query" name:"ImageUri"`
}

// DetectImageTextsResponse is the response struct for api DetectImageTexts
type DetectImageTextsResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	ImageUri  string    `json:"ImageUri" xml:"ImageUri"`
	OCR       []OCRItem `json:"OCR" xml:"OCR"`
}

// CreateDetectImageTextsRequest creates a request to invoke DetectImageTexts API
func CreateDetectImageTextsRequest() (request *DetectImageTextsRequest) {
	request = &DetectImageTextsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DetectImageTexts", "imm", "openAPI")
	return
}

// CreateDetectImageTextsResponse creates a response to parse from DetectImageTexts response
func CreateDetectImageTextsResponse() (response *DetectImageTextsResponse) {
	response = &DetectImageTextsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
