package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDeviceListByIotIds invokes the iot.GetDeviceListByIotIds API synchronously
// api document: https://help.aliyun.com/api/iot/getdevicelistbyiotids.html
func (client *Client) GetDeviceListByIotIds(request *GetDeviceListByIotIdsRequest) (response *GetDeviceListByIotIdsResponse, err error) {
	response = CreateGetDeviceListByIotIdsResponse()
	err = client.DoAction(request, response)
	return
}

// GetDeviceListByIotIdsWithChan invokes the iot.GetDeviceListByIotIds API asynchronously
// api document: https://help.aliyun.com/api/iot/getdevicelistbyiotids.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDeviceListByIotIdsWithChan(request *GetDeviceListByIotIdsRequest) (<-chan *GetDeviceListByIotIdsResponse, <-chan error) {
	responseChan := make(chan *GetDeviceListByIotIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDeviceListByIotIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDeviceListByIotIdsWithCallback invokes the iot.GetDeviceListByIotIds API asynchronously
// api document: https://help.aliyun.com/api/iot/getdevicelistbyiotids.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetDeviceListByIotIdsWithCallback(request *GetDeviceListByIotIdsRequest, callback func(response *GetDeviceListByIotIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDeviceListByIotIdsResponse
		var err error
		defer close(result)
		response, err = client.GetDeviceListByIotIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDeviceListByIotIdsRequest is the request struct for api GetDeviceListByIotIds
type GetDeviceListByIotIdsRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	IotIds          string `position:"Query" name:"IotIds"`
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
}

// GetDeviceListByIotIdsResponse is the response struct for api GetDeviceListByIotIds
type GetDeviceListByIotIdsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateGetDeviceListByIotIdsRequest creates a request to invoke GetDeviceListByIotIds API
func CreateGetDeviceListByIotIdsRequest() (request *GetDeviceListByIotIdsRequest) {
	request = &GetDeviceListByIotIdsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetDeviceListByIotIds", "iot", "openAPI")
	return
}

// CreateGetDeviceListByIotIdsResponse creates a response to parse from GetDeviceListByIotIds response
func CreateGetDeviceListByIotIdsResponse() (response *GetDeviceListByIotIdsResponse) {
	response = &GetDeviceListByIotIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
