package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveRealtimeLogDeliveryDomains invokes the live.ListLiveRealtimeLogDeliveryDomains API synchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdeliverydomains.html
func (client *Client) ListLiveRealtimeLogDeliveryDomains(request *ListLiveRealtimeLogDeliveryDomainsRequest) (response *ListLiveRealtimeLogDeliveryDomainsResponse, err error) {
	response = CreateListLiveRealtimeLogDeliveryDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveRealtimeLogDeliveryDomainsWithChan invokes the live.ListLiveRealtimeLogDeliveryDomains API asynchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdeliverydomains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListLiveRealtimeLogDeliveryDomainsWithChan(request *ListLiveRealtimeLogDeliveryDomainsRequest) (<-chan *ListLiveRealtimeLogDeliveryDomainsResponse, <-chan error) {
	responseChan := make(chan *ListLiveRealtimeLogDeliveryDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveRealtimeLogDeliveryDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveRealtimeLogDeliveryDomainsWithCallback invokes the live.ListLiveRealtimeLogDeliveryDomains API asynchronously
// api document: https://help.aliyun.com/api/live/listliverealtimelogdeliverydomains.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListLiveRealtimeLogDeliveryDomainsWithCallback(request *ListLiveRealtimeLogDeliveryDomainsRequest, callback func(response *ListLiveRealtimeLogDeliveryDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveRealtimeLogDeliveryDomainsResponse
		var err error
		defer close(result)
		response, err = client.ListLiveRealtimeLogDeliveryDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveRealtimeLogDeliveryDomainsRequest is the request struct for api ListLiveRealtimeLogDeliveryDomains
type ListLiveRealtimeLogDeliveryDomainsRequest struct {
	*requests.RpcRequest
	Project  string           `position:"Query" name:"Project"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	Region   string           `position:"Query" name:"Region"`
	Logstore string           `position:"Query" name:"Logstore"`
}

// ListLiveRealtimeLogDeliveryDomainsResponse is the response struct for api ListLiveRealtimeLogDeliveryDomains
type ListLiveRealtimeLogDeliveryDomainsResponse struct {
	*responses.BaseResponse
	RequestId string                                      `json:"RequestId" xml:"RequestId"`
	Content   ContentInListLiveRealtimeLogDeliveryDomains `json:"Content" xml:"Content"`
}

// CreateListLiveRealtimeLogDeliveryDomainsRequest creates a request to invoke ListLiveRealtimeLogDeliveryDomains API
func CreateListLiveRealtimeLogDeliveryDomainsRequest() (request *ListLiveRealtimeLogDeliveryDomainsRequest) {
	request = &ListLiveRealtimeLogDeliveryDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveRealtimeLogDeliveryDomains", "live", "openAPI")
	return
}

// CreateListLiveRealtimeLogDeliveryDomainsResponse creates a response to parse from ListLiveRealtimeLogDeliveryDomains response
func CreateListLiveRealtimeLogDeliveryDomainsResponse() (response *ListLiveRealtimeLogDeliveryDomainsResponse) {
	response = &ListLiveRealtimeLogDeliveryDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
