package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExchangeAudio invokes the qualitycheck.ExchangeAudio API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/exchangeaudio.html
func (client *Client) ExchangeAudio(request *ExchangeAudioRequest) (response *ExchangeAudioResponse, err error) {
	response = CreateExchangeAudioResponse()
	err = client.DoAction(request, response)
	return
}

// ExchangeAudioWithChan invokes the qualitycheck.ExchangeAudio API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/exchangeaudio.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExchangeAudioWithChan(request *ExchangeAudioRequest) (<-chan *ExchangeAudioResponse, <-chan error) {
	responseChan := make(chan *ExchangeAudioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExchangeAudio(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExchangeAudioWithCallback invokes the qualitycheck.ExchangeAudio API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/exchangeaudio.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExchangeAudioWithCallback(request *ExchangeAudioRequest, callback func(response *ExchangeAudioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExchangeAudioResponse
		var err error
		defer close(result)
		response, err = client.ExchangeAudio(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExchangeAudioRequest is the request struct for api ExchangeAudio
type ExchangeAudioRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// ExchangeAudioResponse is the response struct for api ExchangeAudio
type ExchangeAudioResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateExchangeAudioRequest creates a request to invoke ExchangeAudio API
func CreateExchangeAudioRequest() (request *ExchangeAudioRequest) {
	request = &ExchangeAudioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ExchangeAudio", "", "")
	return
}

// CreateExchangeAudioResponse creates a response to parse from ExchangeAudio response
func CreateExchangeAudioResponse() (response *ExchangeAudioResponse) {
	response = &ExchangeAudioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
