package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateCustomizationModelId invokes the qualitycheck.GenerateCustomizationModelId API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/generatecustomizationmodelid.html
func (client *Client) GenerateCustomizationModelId(request *GenerateCustomizationModelIdRequest) (response *GenerateCustomizationModelIdResponse, err error) {
	response = CreateGenerateCustomizationModelIdResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateCustomizationModelIdWithChan invokes the qualitycheck.GenerateCustomizationModelId API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/generatecustomizationmodelid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateCustomizationModelIdWithChan(request *GenerateCustomizationModelIdRequest) (<-chan *GenerateCustomizationModelIdResponse, <-chan error) {
	responseChan := make(chan *GenerateCustomizationModelIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateCustomizationModelId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateCustomizationModelIdWithCallback invokes the qualitycheck.GenerateCustomizationModelId API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/generatecustomizationmodelid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateCustomizationModelIdWithCallback(request *GenerateCustomizationModelIdRequest, callback func(response *GenerateCustomizationModelIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateCustomizationModelIdResponse
		var err error
		defer close(result)
		response, err = client.GenerateCustomizationModelId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateCustomizationModelIdRequest is the request struct for api GenerateCustomizationModelId
type GenerateCustomizationModelIdRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// GenerateCustomizationModelIdResponse is the response struct for api GenerateCustomizationModelId
type GenerateCustomizationModelIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGenerateCustomizationModelIdRequest creates a request to invoke GenerateCustomizationModelId API
func CreateGenerateCustomizationModelIdRequest() (request *GenerateCustomizationModelIdRequest) {
	request = &GenerateCustomizationModelIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GenerateCustomizationModelId", "", "")
	return
}

// CreateGenerateCustomizationModelIdResponse creates a response to parse from GenerateCustomizationModelId response
func CreateGenerateCustomizationModelIdResponse() (response *GenerateCustomizationModelIdResponse) {
	response = &GenerateCustomizationModelIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
