package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResultCount invokes the qualitycheck.GetResultCount API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/getresultcount.html
func (client *Client) GetResultCount(request *GetResultCountRequest) (response *GetResultCountResponse, err error) {
	response = CreateGetResultCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetResultCountWithChan invokes the qualitycheck.GetResultCount API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getresultcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetResultCountWithChan(request *GetResultCountRequest) (<-chan *GetResultCountResponse, <-chan error) {
	responseChan := make(chan *GetResultCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResultCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResultCountWithCallback invokes the qualitycheck.GetResultCount API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/getresultcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetResultCountWithCallback(request *GetResultCountRequest, callback func(response *GetResultCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResultCountResponse
		var err error
		defer close(result)
		response, err = client.GetResultCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResultCountRequest is the request struct for api GetResultCount
type GetResultCountRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetResultCountResponse is the response struct for api GetResultCount
type GetResultCountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      int    `json:"Data" xml:"Data"`
}

// CreateGetResultCountRequest creates a request to invoke GetResultCount API
func CreateGetResultCountRequest() (request *GetResultCountRequest) {
	request = &GetResultCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetResultCount", "", "")
	return
}

// CreateGetResultCountResponse creates a response to parse from GetResultCount response
func CreateGetResultCountResponse() (response *GetResultCountResponse) {
	response = &GetResultCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
