package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskRuleList invokes the qualitycheck.GetTaskRuleList API synchronously
// api document: https://help.aliyun.com/api/qualitycheck/gettaskrulelist.html
func (client *Client) GetTaskRuleList(request *GetTaskRuleListRequest) (response *GetTaskRuleListResponse, err error) {
	response = CreateGetTaskRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskRuleListWithChan invokes the qualitycheck.GetTaskRuleList API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/gettaskrulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskRuleListWithChan(request *GetTaskRuleListRequest) (<-chan *GetTaskRuleListResponse, <-chan error) {
	responseChan := make(chan *GetTaskRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskRuleListWithCallback invokes the qualitycheck.GetTaskRuleList API asynchronously
// api document: https://help.aliyun.com/api/qualitycheck/gettaskrulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskRuleListWithCallback(request *GetTaskRuleListRequest, callback func(response *GetTaskRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskRuleListResponse
		var err error
		defer close(result)
		response, err = client.GetTaskRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskRuleListRequest is the request struct for api GetTaskRuleList
type GetTaskRuleListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetTaskRuleListResponse is the response struct for api GetTaskRuleList
type GetTaskRuleListResponse struct {
	*responses.BaseResponse
	RequestId         string                `json:"RequestId" xml:"RequestId"`
	Success           bool                  `json:"Success" xml:"Success"`
	Code              string                `json:"Code" xml:"Code"`
	Message           string                `json:"Message" xml:"Message"`
	PageSize          int                   `json:"PageSize" xml:"PageSize"`
	DataSize          int                   `json:"DataSize" xml:"DataSize"`
	TotalCount        int                   `json:"TotalCount" xml:"TotalCount"`
	ReviewStatus      int                   `json:"ReviewStatus" xml:"ReviewStatus"`
	TotalSubTaskCount int                   `json:"TotalSubTaskCount" xml:"TotalSubTaskCount"`
	CompSubTaskCount  int                   `json:"CompSubTaskCount" xml:"CompSubTaskCount"`
	CurrentPage       int                   `json:"CurrentPage" xml:"CurrentPage"`
	Data              DataInGetTaskRuleList `json:"Data" xml:"Data"`
}

// CreateGetTaskRuleListRequest creates a request to invoke GetTaskRuleList API
func CreateGetTaskRuleListRequest() (request *GetTaskRuleListRequest) {
	request = &GetTaskRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetTaskRuleList", "", "")
	return
}

// CreateGetTaskRuleListResponse creates a response to parse from GetTaskRuleList response
func CreateGetTaskRuleListResponse() (response *GetTaskRuleListResponse) {
	response = &GetTaskRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
