package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeShardingInstances invokes the r_kvstore.DescribeShardingInstances API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeshardinginstances.html
func (client *Client) DescribeShardingInstances(request *DescribeShardingInstancesRequest) (response *DescribeShardingInstancesResponse, err error) {
	response = CreateDescribeShardingInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeShardingInstancesWithChan invokes the r_kvstore.DescribeShardingInstances API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeshardinginstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeShardingInstancesWithChan(request *DescribeShardingInstancesRequest) (<-chan *DescribeShardingInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeShardingInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeShardingInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeShardingInstancesWithCallback invokes the r_kvstore.DescribeShardingInstances API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describeshardinginstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeShardingInstancesWithCallback(request *DescribeShardingInstancesRequest, callback func(response *DescribeShardingInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeShardingInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeShardingInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeShardingInstancesRequest is the request struct for api DescribeShardingInstances
type DescribeShardingInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceIds          string           `position:"Query" name:"InstanceIds"`
}

// DescribeShardingInstancesResponse is the response struct for api DescribeShardingInstances
type DescribeShardingInstancesResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	Instances  []Instance `json:"Instances" xml:"Instances"`
}

// CreateDescribeShardingInstancesRequest creates a request to invoke DescribeShardingInstances API
func CreateDescribeShardingInstancesRequest() (request *DescribeShardingInstancesRequest) {
	request = &DescribeShardingInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeShardingInstances", "", "")
	return
}

// CreateDescribeShardingInstancesResponse creates a response to parse from DescribeShardingInstances response
func CreateDescribeShardingInstancesResponse() (response *DescribeShardingInstancesResponse) {
	response = &DescribeShardingInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
