package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTask invokes the r_kvstore.QueryTask API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/querytask.html
func (client *Client) QueryTask(request *QueryTaskRequest) (response *QueryTaskResponse, err error) {
	response = CreateQueryTaskResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskWithChan invokes the r_kvstore.QueryTask API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/querytask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskWithChan(request *QueryTaskRequest) (<-chan *QueryTaskResponse, <-chan error) {
	responseChan := make(chan *QueryTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskWithCallback invokes the r_kvstore.QueryTask API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/querytask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskWithCallback(request *QueryTaskRequest, callback func(response *QueryTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskResponse
		var err error
		defer close(result)
		response, err = client.QueryTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskRequest is the request struct for api QueryTask
type QueryTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryTaskResponse is the response struct for api QueryTask
type QueryTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Action    string `json:"Action" xml:"Action"`
	Progress  int    `json:"Progress" xml:"Progress"`
}

// CreateQueryTaskRequest creates a request to invoke QueryTask API
func CreateQueryTaskRequest() (request *QueryTaskRequest) {
	request = &QueryTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "QueryTask", "", "")
	return
}

// CreateQueryTaskResponse creates a response to parse from QueryTask response
func CreateQueryTaskResponse() (response *QueryTaskResponse) {
	response = &QueryTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
