package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDedicatedHostGroup invokes the rds.CreateDedicatedHostGroup API synchronously
// api document: https://help.aliyun.com/api/rds/creatededicatedhostgroup.html
func (client *Client) CreateDedicatedHostGroup(request *CreateDedicatedHostGroupRequest) (response *CreateDedicatedHostGroupResponse, err error) {
	response = CreateCreateDedicatedHostGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDedicatedHostGroupWithChan invokes the rds.CreateDedicatedHostGroup API asynchronously
// api document: https://help.aliyun.com/api/rds/creatededicatedhostgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedHostGroupWithChan(request *CreateDedicatedHostGroupRequest) (<-chan *CreateDedicatedHostGroupResponse, <-chan error) {
	responseChan := make(chan *CreateDedicatedHostGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDedicatedHostGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDedicatedHostGroupWithCallback invokes the rds.CreateDedicatedHostGroup API asynchronously
// api document: https://help.aliyun.com/api/rds/creatededicatedhostgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDedicatedHostGroupWithCallback(request *CreateDedicatedHostGroupRequest, callback func(response *CreateDedicatedHostGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDedicatedHostGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateDedicatedHostGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDedicatedHostGroupRequest is the request struct for api CreateDedicatedHostGroup
type CreateDedicatedHostGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CpuAllocationRatio   requests.Integer `position:"Query" name:"CpuAllocationRatio"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Engine               string           `position:"Query" name:"Engine"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DiskAllocationRatio  requests.Integer `position:"Query" name:"DiskAllocationRatio"`
	MemAllocationRatio   requests.Integer `position:"Query" name:"MemAllocationRatio"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	HostReplacePolicy    string           `position:"Query" name:"HostReplacePolicy"`
	AllocationPolicy     string           `position:"Query" name:"AllocationPolicy"`
	VPCId                string           `position:"Query" name:"VPCId"`
}

// CreateDedicatedHostGroupResponse is the response struct for api CreateDedicatedHostGroup
type CreateDedicatedHostGroupResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	DedicatedHostGroupId string `json:"DedicatedHostGroupId" xml:"DedicatedHostGroupId"`
}

// CreateCreateDedicatedHostGroupRequest creates a request to invoke CreateDedicatedHostGroup API
func CreateCreateDedicatedHostGroupRequest() (request *CreateDedicatedHostGroupRequest) {
	request = &CreateDedicatedHostGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateDedicatedHostGroup", "rds", "openAPI")
	return
}

// CreateCreateDedicatedHostGroupResponse creates a response to parse from CreateDedicatedHostGroup response
func CreateCreateDedicatedHostGroupResponse() (response *CreateDedicatedHostGroupResponse) {
	response = &CreateDedicatedHostGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
