package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePolicyBasedRoutings invokes the smartag.DescribePolicyBasedRoutings API synchronously
// api document: https://help.aliyun.com/api/smartag/describepolicybasedroutings.html
func (client *Client) DescribePolicyBasedRoutings(request *DescribePolicyBasedRoutingsRequest) (response *DescribePolicyBasedRoutingsResponse, err error) {
	response = CreateDescribePolicyBasedRoutingsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePolicyBasedRoutingsWithChan invokes the smartag.DescribePolicyBasedRoutings API asynchronously
// api document: https://help.aliyun.com/api/smartag/describepolicybasedroutings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePolicyBasedRoutingsWithChan(request *DescribePolicyBasedRoutingsRequest) (<-chan *DescribePolicyBasedRoutingsResponse, <-chan error) {
	responseChan := make(chan *DescribePolicyBasedRoutingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePolicyBasedRoutings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePolicyBasedRoutingsWithCallback invokes the smartag.DescribePolicyBasedRoutings API asynchronously
// api document: https://help.aliyun.com/api/smartag/describepolicybasedroutings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePolicyBasedRoutingsWithCallback(request *DescribePolicyBasedRoutingsRequest, callback func(response *DescribePolicyBasedRoutingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePolicyBasedRoutingsResponse
		var err error
		defer close(result)
		response, err = client.DescribePolicyBasedRoutings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePolicyBasedRoutingsRequest is the request struct for api DescribePolicyBasedRoutings
type DescribePolicyBasedRoutingsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	PbrInstanceId        string           `position:"Query" name:"PbrInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribePolicyBasedRoutingsResponse is the response struct for api DescribePolicyBasedRoutings
type DescribePolicyBasedRoutingsResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	TotalCount          int                 `json:"TotalCount" xml:"TotalCount"`
	PageNumber          int                 `json:"PageNumber" xml:"PageNumber"`
	PageSize            int                 `json:"PageSize" xml:"PageSize"`
	PolicyBasedRoutings PolicyBasedRoutings `json:"PolicyBasedRoutings" xml:"PolicyBasedRoutings"`
}

// CreateDescribePolicyBasedRoutingsRequest creates a request to invoke DescribePolicyBasedRoutings API
func CreateDescribePolicyBasedRoutingsRequest() (request *DescribePolicyBasedRoutingsRequest) {
	request = &DescribePolicyBasedRoutingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribePolicyBasedRoutings", "smartag", "openAPI")
	return
}

// CreateDescribePolicyBasedRoutingsResponse creates a response to parse from DescribePolicyBasedRoutings response
func CreateDescribePolicyBasedRoutingsResponse() (response *DescribePolicyBasedRoutingsResponse) {
	response = &DescribePolicyBasedRoutingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
