package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNotaryOrders invokes the trademark.ListNotaryOrders API synchronously
// api document: https://help.aliyun.com/api/trademark/listnotaryorders.html
func (client *Client) ListNotaryOrders(request *ListNotaryOrdersRequest) (response *ListNotaryOrdersResponse, err error) {
	response = CreateListNotaryOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// ListNotaryOrdersWithChan invokes the trademark.ListNotaryOrders API asynchronously
// api document: https://help.aliyun.com/api/trademark/listnotaryorders.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNotaryOrdersWithChan(request *ListNotaryOrdersRequest) (<-chan *ListNotaryOrdersResponse, <-chan error) {
	responseChan := make(chan *ListNotaryOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNotaryOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNotaryOrdersWithCallback invokes the trademark.ListNotaryOrders API asynchronously
// api document: https://help.aliyun.com/api/trademark/listnotaryorders.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNotaryOrdersWithCallback(request *ListNotaryOrdersRequest, callback func(response *ListNotaryOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNotaryOrdersResponse
		var err error
		defer close(result)
		response, err = client.ListNotaryOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNotaryOrdersRequest is the request struct for api ListNotaryOrders
type ListNotaryOrdersRequest struct {
	*requests.RpcRequest
	SortKeyType    requests.Integer `position:"Query" name:"SortKeyType"`
	SortByType     string           `position:"Query" name:"SortByType"`
	StartOrderDate requests.Integer `position:"Query" name:"StartOrderDate"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	BizId          string           `position:"Query" name:"BizId"`
	NotaryType     requests.Integer `position:"Query" name:"NotaryType"`
	EndOrderDate   requests.Integer `position:"Query" name:"EndOrderDate"`
	AliyunOrderId  string           `position:"Query" name:"AliyunOrderId"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	NotaryStatus   requests.Integer `position:"Query" name:"NotaryStatus"`
}

// ListNotaryOrdersResponse is the response struct for api ListNotaryOrders
type ListNotaryOrdersResponse struct {
	*responses.BaseResponse
	RequestId      string                 `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int                    `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int                    `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int                    `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                    `json:"TotalPageNum" xml:"TotalPageNum"`
	PrePage        bool                   `json:"PrePage" xml:"PrePage"`
	NextPage       bool                   `json:"NextPage" xml:"NextPage"`
	Success        bool                   `json:"Success" xml:"Success"`
	ErrorMsg       string                 `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string                 `json:"ErrorCode" xml:"ErrorCode"`
	Data           DataInListNotaryOrders `json:"Data" xml:"Data"`
}

// CreateListNotaryOrdersRequest creates a request to invoke ListNotaryOrders API
func CreateListNotaryOrdersRequest() (request *ListNotaryOrdersRequest) {
	request = &ListNotaryOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "ListNotaryOrders", "trademark", "openAPI")
	return
}

// CreateListNotaryOrdersResponse creates a response to parse from ListNotaryOrders response
func CreateListNotaryOrdersResponse() (response *ListNotaryOrdersResponse) {
	response = &ListNotaryOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
